$(document).ready(function(){
   var preventClick=false;
   $(".pic a").bind("click",function(e){
      if(preventClick){
         e.stopImmediatePropagation();
         e.preventDefault();
      }
   });

   $(".pic").draggable({
      containment: "parent",
      start: function(e,ui){
         preventClick=true;
      },
      stop: function(e, ui) {
         setTimeout(function(){ preventClick=false; }, 250);
      }
   });

   $(".pic").mousedown(function(e){
      var maxZ = 0;
      $(".pic").each(function(){
         var thisZ = parseInt($(this).css("zIndex"))
         if(thisZ>maxZ) maxZ=thisZ;
   });
   if($(e.target).hasClass("pic")){
      $(e.target).css({zIndex:maxZ+1});
   }
   else $(e.target).closest(".pic").css({zIndex:maxZ+1});
   });
   $("a.fancybox").fancybox({
      zoomSpeedIn: 300,
      zoomSpeedOut: 300,
      overlayShow:false
   });
   $(".drop-box").droppable({
      hoverClass: "active",
      drop:function(event,ui){
        $("#url").val(location.href.replace(location.hash,"")+"#"+ui.draggable.attr("id"));
        $("#modal").dialog("open");
      }
   });
   $("#modal").dialog({
      bgiframe: true,
      modal: true,
      autoOpen:false,
      buttons: {
         Ok: function() {
            $(this).dialog("close");
         }
      }
   });
   if(location.hash.indexOf("#pic-")!=-1){
      $(location.hash+" a.fancybox").click();
   }
});
