//quiz vídeo
var vid = {
  // (A) PROPIEDADE 
  // (A1) PREGUNTAS E RESPOTAS
  // Q = QUESTION, O = OPTIONS, A = CORRECT ANSWER
  //video1= Kaliwoda --- video2 = Mazas ---- video3= TElemann 
  data: [
  {
    q : "https://www.youtube.com/embed/6rsMKZ4809A", 
    o : [
      "J. F. Mazas: Estudio Mazas op. 36 nº 2",
      "G. Ph. Telemann: 1º mov. Concerto",
      "J. Kaliwoda: Noturno nº 4"
    ],
    a : 2 // arrays start with 0, so answer is kaliwoda
  },
  {
    q : "https://www.youtube.com/embed/Kn6IY3X1q_8",
    o : [
		"G. Ph. Telemann: 1º mov. Concerto",
		"J. Kaliwoda: Noturno nº 4",
		"J. F. Mazas: Estudio Mazas op. 36 nº 2" 
    ],
    a : 2
  },
  {
    q : "https://www.youtube.com/embed/_AmWZt7qddg",
    o : [
      "G. Ph. Telemann: 1º mov. Concerto",
      "J. F. Mazas: Estudio Mazas op. 36 nº 2",
      "J. Kaliwoda: Noturno nº 4"
    ],
    a : 0
  },
  ],
  
  // (A2) HTML ELEMENTS
  vWrap: null, // HTML quiz container
  vQn: null, // HTML question wrapper
  vAns: null, // HTML answers wrapper

  // (A3) GAME FLAGSwrapper
  now: 0, // current question
  score: 0, // current score
  
  // (B) INIT QUIZ HTML
  init: function(){
    // (B1) WRAPPER
    vid.vWrap = document.getElementById("vWrap");

    // (B2) QUESTIONS SECTION
    vid.vQn = document.getElementById("vQn");

    // (B3) ANSWERS SECTION
    vid.vAns = document.createElement("div");
    vid.vAns.id = "vAns";
    vid.vWrap.appendChild(vid.vAns);
    
    // (B4) Total preguntas
    vid.vTot = document.createElement("div");
    vid.vWrap.appendChild(vid.vTot);
    
    
    

// (B5) ANSWERS SECTION
    vid.vRes = document.createElement("div");
    vid.vRes.id = "vRes";
    vid.vWrap.appendChild(vid.vRes);
    
    // (B6) GO!
    vid.draw();
      
  },
  
   // (C) DRAW QUESTION
  draw: function(){
    // (C1) QUESTION
    vid.vQn.src = vid.data[vid.now].q;

    // (C2) OPTIONS
    vid.vAns.innerHTML = "";
    for (let i in vid.data[vid.now].o) {
      let radio = document.createElement("input");
      radio.type = "radio";
      radio.name = "vid";
      radio.id = "vido" + i;
      vid.vAns.appendChild(radio);
      radio.setAttribute("class", "hidden");
      
      let label = document.createElement("label");
      label.innerHTML = vid.data[vid.now].o[i];
      label.setAttribute("for", "vido" + i);
      label.setAttribute("class", "preguntas" );
      label.dataset.idx = i;
      label.addEventListener("click", vid.select);
      vid.vAns.appendChild(label);
      
      
      
    }
  },
  
   // (D) OPTION SELECTED
  select: function(){
    // (D1) DETACH ALL ONCLICK
    let all = vid.vAns.getElementsByTagName("label");
    for (let label of all) {
      label.removeEventListener("click", vid.select);
    }

    // (D2) CHECK IF CORRECT
    let correct = this.dataset.idx == vid.data[vid.now].a;
    if (correct) { 
      vid.score++; 
      this.classList.add("correct");
    } else {
      this.classList.add("wrong");
    }
  
    // (D3) NEXT QUESTION OR END GAME
    vid.now++;
    setTimeout(function(){
      if (vid.now < vid.data.length) { vid.draw();} 
      else {
        vid.vRes.innerHTML = `<h4>Acertaches ${vid.score} de ${vid.data.length}</h4>
        <input type="button" value="Recomezar" class="button primary small" onclick="location.reload()">`;
        vid.vAns.innerHTML = "";
        vid.vTot.innerHTML = "";
      }
    }, 1000);
  }
};
window.addEventListener("load", vid.init);


//quiz audio
var audi = {
  // (A) PROPERTIES 
  // (A1) QUESTIONS & ANSWERS
  // Q = QUESTION, O = OPTIONS, A = CORRECT ANSWER
  //audio1= Kaliwoda --- audio2 = Telemann2 ---- audio3= Seitz  ---- audio4 = Telemann1
  data: [
  {
    q : "audio/memoria/audio1.mp3",
    o : [
      "J. Kaliwoda: Noturno nº 4",
      "G. Ph. Telemann: 1º mov. Concerto",
      "F. Seitz: Concerto nº 2",
      "G. Ph. Telemann: 2º mov. Concerto"
    ],
    a : 0 // arrays start with 0, so answer is kaliwoda
  },
  {
    q : "audio/memoria/audio2.mp3",
    o : [
		"G. Ph. Telemann: 1º mov. Concerto",
		"J. Kaliwoda: Noturno nº 4",
		"G. Ph. Telemann: 2º mov. Concerto",
      "F. Seitz: Concerto nº 2"
      
    ],
    a : 2
  },
  {
    q : "audio/memoria/audio3.mp3",
    o : [
      "F. Seitz: Concerto nº 2",
      "G. Ph. Telemann: 1º mov. Concerto",
      "J. Kaliwoda: Noturno nº 4",
      "G. Ph. Telemann: 2º mov. Concerto"
    ],
    a : 0
  },
  {
    q : "audio/memoria/audio4.mp3",
    o : [
      "F. Seitz: Concerto nº 2",
      "G. Ph. Telemann: 1º mov. Concerto",
      "J. Kaliwoda: Noturno nº 4",
      "G. Ph. Telemann: 2º mov. Concerto"
    ],
    a : 1
  },
  ],
  
  // (A2) HTML ELEMENTS
  aWrap: null, // HTML quiz container
  aQn: null, // HTML question wrapper
  aAns: null, // HTML answers wrapper

  // (A3) GAME FLAGS
  now: 0, // current question
  score: 0, // current score
  
  // (B) INIT QUIZ HTML
  init: function(){
    // (B1) WRAPPER
    audi.aWrap = document.getElementById("aWrap");

    // (B2) QUESTIONS SECTION
    audi.aQn = document.getElementById("aQn");

    // (B3) ANSWERS SECTION
    audi.aAns = document.createElement("div");
    audi.aAns.id = "aAns";
    audi.aWrap.appendChild(audi.aAns);
    

// (B4) ANSWERS SECTION
    audi.aRes = document.createElement("div");
    audi.aRes.id = "aRes";
    audi.aWrap.appendChild(audi.aRes);
    
    // (B5) GO!
    audi.draw();
      
  },
  
   // (C) DRAW QUESTION
  draw: function(){
    // (C1) QUESTION
    audi.aQn.src = audi.data[audi.now].q;

    // (C2) OPTIONS
    audi.aAns.innerHTML = "";
    for (let i in audi.data[audi.now].o) {
      let radio = document.createElement("input");
      radio.type = "radio";
      radio.name = "audi";
      radio.id = "audio" + i;
      audi.aAns.appendChild(radio);
      radio.setAttribute("class", "hidden");
      
      let label = document.createElement("label");
      label.innerHTML = audi.data[audi.now].o[i];
      label.setAttribute("for", "audio" + i);
      label.setAttribute("class", "preguntas" );
      label.dataset.idx = i;
      label.addEventListener("click", audi.select);
      audi.aAns.appendChild(label);
      
    }
  },
  
   // (D) OPTION SELECTED
  select: function(){
    // (D1) DETACH ALL ONCLICK
    let all = audi.aAns.getElementsByTagName("label");
    for (let label of all) {
      label.removeEventListener("click", audi.select);
    }

    // (D2) CHECK IF CORRECT
    let correct = this.dataset.idx == audi.data[audi.now].a;
    if (correct) { 
      audi.score++; 
      this.classList.add("correct");
    } else {
      this.classList.add("wrong");
    }
  
    // (D3) NEXT QUESTION OR END GAME
    audi.now++;
    setTimeout(function(){
      if (audi.now < audi.data.length) { audi.draw(); } 
      else {
        audi.aRes.innerHTML = `<h4>Acertaches ${audi.score} de ${audi.data.length}</h4>
        <input type="button" value="Recomezar" class="button primary small" onclick="location.reload()">`;
        // audi.aRes.setAttribute("class", "button")
        audi.aAns.innerHTML = "";
      }
    }, 1000);
  }
};
window.addEventListener("load", audi.init);


// partituras
var quiz = {
  // (A) PROPERTIES 
  // (A1) QUESTIONS & ANSWERS
  // Q = QUESTION, O = OPTIONS, A = CORRECT ANSWER
  //part1= Telemann1 --- part2 = Mazas ---- part3= Kaliwoda  ---- part4 = Telemann 2
  data: [
  {
    q : "images/partituras/memoria/part1.png",
    o : [
      "J. Kaliwoda: Noturno nº 4",
      "G. Ph. Telemann: 1º mov. Concerto",
      "J. F. Mazas: Estudio Mazas op. 36 nº 2",
      "G. Ph. Telemann: 2º mov. Concerto"
    ],
    a : 1 // arrays start with 0, so answer is Telemann
  },
  {
    q : "images/partituras/memoria/part2.png",
    o : [
		"G. Ph. Telemann: 1º mov. Concerto",
		"J. Kaliwoda: Noturno nº 4",
		"G. Ph. Telemann: 2º mov. Concerto",
      "J. F. Mazas: Estudio Mazas op. 36 nº 2"
      
    ],
    a : 3
  },
  {
    q : "images/partituras/memoria/part3.png",
    o : [
      "J. F. Mazas: Estudio Mazas op. 36 nº 2",
      "G. Ph. Telemann: 1º mov. Concerto",
      "J. Kaliwoda: Noturno nº 4",
      "G. Ph. Telemann: 2º mov. Concerto"
    ],
    a : 2
  },
  {
    q : "images/partituras/memoria/part4.png",
    o : [
       "G. Ph. Telemann: 2º mov. Concerto",
       "J. Kaliwoda: Noturno nº 4",
      "G. Ph. Telemann: 1º mov. Concerto",
      "J. F. Mazas: Estudio Mazas op. 36 nº 2"
     
    ],
    a : 0
  },
  ],

  // (A2) HTML ELEMENTS
  hWrap: null, // HTML quiz container
  hQn: null, // HTML question wrapper
  hAns: null, // HTML answers wrapper

  // (A3) GAME FLAGS
  now: 0, // current question
  score: 0, // current score

  // (B) INIT QUIZ HTML
  init: function(){
    // (B1) WRAPPER
    quiz.hWrap = document.getElementById("quizWrap");

    // (B2) QUESTIONS SECTION
    quiz.hQn = document.getElementById("quizQn");

    // (B3) ANSWERS SECTION
    quiz.hAns = document.createElement("div");
    quiz.hAns.id = "quizAns";
    quiz.hWrap.appendChild(quiz.hAns);
    

// (B4) ANSWERS SECTION
    quiz.hRes = document.createElement("div");
    quiz.hRes.id = "quizRes";
    quiz.hWrap.appendChild(quiz.hRes);
    
    // (B5) GO!
    quiz.draw();
  },

  // (C) DRAW QUESTION
  draw: function(){
    // (C1) QUESTION
    quiz.hQn.src = quiz.data[quiz.now].q;

    // (C2) OPTIONS
    quiz.hAns.innerHTML = "";
    for (let i in quiz.data[quiz.now].o) {
      let radio = document.createElement("input");
      radio.type = "radio";
      radio.name = "quiz";
      radio.id = "quizo" + i;
      quiz.hAns.appendChild(radio);
      radio.setAttribute("class", "hidden");
      
      let label = document.createElement("label");
      label.innerHTML = quiz.data[quiz.now].o[i];
      label.setAttribute("for", "quizo" + i);
      label.setAttribute("class", "preguntas" );
      label.dataset.idx = i;
      label.addEventListener("click", quiz.select);
      quiz.hAns.appendChild(label);
      
    }
  },
  
  // (D) OPTION SELECTED
  select: function(){
    // (D1) DETACH ALL ONCLICK
    let all = quiz.hAns.getElementsByTagName("label");
    for (let label of all) {
      label.removeEventListener("click", quiz.select);
    }

    // (D2) CHECK IF CORRECT
    let correct = this.dataset.idx == quiz.data[quiz.now].a;
    if (correct) { 
      quiz.score++; 
      this.classList.add("correct");
    } else {
      this.classList.add("wrong");
    }
  
    // (D3) NEXT QUESTION OR END GAME
    quiz.now++;
    setTimeout(function(){
      if (quiz.now < quiz.data.length) { quiz.draw(); } 
      else {
        quiz.hRes.innerHTML = `<h4>Acertaches ${quiz.score} de ${quiz.data.length}</h4>
        <input type="button" value="Recomezar" class="button primary small" onclick="location.reload()">`;
        // quiz.hRes.setAttribute("class", "button")
        quiz.hAns.innerHTML = "";
      }
    }, 1000);
  }
};
window.addEventListener("load", quiz.init);

