

var Partida = Backbone.Model.extend(
    {
        defaults: {
            id: "",
            id_juego: "",
            centro: "",
            clase: "",
            fecha: "",
            data: null,
        },
        initialize: function(attr){
            initObj = new Object();
            initObj.turno = 0;
            this.set("data", initObj);
        },
        setValues: function(_data){
            
        },
        getJSON: function(){
           var _data = new Object();
           _data.id = this.get("id");
           _data.id_juego = this.get("id_juego");
           _data.centro = this.get("centro");
           _data.clase = this.get("clase");
           _data.fecha = this.get("fecha");
           _data.data = this.get("data");
           return _data;
        },
    }
);

var Categoria = Backbone.Model.extend(
    {
        defaults: {
            id_categoria: "",
            nombre: "",
        },
        initialize: function(attr){
            this.set("id_categoria", attr.id);
        },
        setValues: function(_data){
        },
        getJSON: function(){
           var _data = new Object();
           _data.id_categoria = this.get("id_categoria");
           _data.nombre = this.get("nombre");
           return _data;
        },
    }
);


var Tarjeta = Backbone.Model.extend(
    {
        defaults: {
            id: "",
            id_categoria: "",
            imagen: "",
            respuesta_ok: "",
            enlace: "",
            descripcion: "",
            origen: "",
            pregunta: "",
            respuesta1: "",
            respuesta2: "",
            respuesta3: "",
            recursos: "",
        },
        initialize: function(attr){
        },
        setValues: function(_data){
        },
        getJSON: function(){
           var _data = new Object();
           _data.id = this.get("id");
           _data.id_categoria = this.get("id_categoria");
           _data.imagen = this.get("imagen");
           _data.respuesta_ok = this.get("respuesta_ok");
           _data.enlace = this.get("enlace");
           _data.descripcion = this.get("descripcion");
           _data.origen = this.get("origen");
           _data.pregunta = this.get("pregunta");
           _data.respuesta1 = this.get("respuesta1");
           _data.respuesta2 = this.get("respuesta2");
           _data.respuesta3 = this.get("respuesta3");
           _data.recursos = this.get("recursos");
           return _data;
        },
    }
);

var User = Backbone.Model.extend(
    {
        defaults: {
            id:0,
            nombre:"",
            color:"",
            status:1,
            puntos:0,
            avatar:null,
            puntosAcierto:0,
        },
        initialize: function(attr){
            this.set("id", this.cid);
        },
        setValues: function(_data){
        },
        getJSON: function(){
           var _data = new Object();
           _data.id = this.get("id");
           _data.nombre = this.get("nombre");
           _data.color = this.get("color");
           _data.status = this.get("status");
           _data.puntos = this.get("puntos");
           _data.puntosAcierto = this.get("puntosAcierto");
          // _data.avatar = this.get("avatar");
           return _data;
        },
    }
);



 var TarjetasCollection = Backbone.Collection.extend(
      {
        model:Tarjeta,
        sort_key: "id",
        order: 1,
        comparator: function(a,b){
            //return item.get(this.sort_key);
            if(this.sort_key == "id"){
                value1 = a.get(this.sort_key);
                value2 = b.get(this.sort_key);
            }else{
                value1 = a.get(this.sort_key).toLowerCase();
                value2 = b.get(this.sort_key).toLowerCase();
            }
            
            if (value1 < value2){
              ret = -1;
            }else if (value1 > value2){
                ret = 1;
            }else{
                ret = 0;
            }
            return this.order * ret;
        },
        sortByField: function(campo){
          this.sort_key = campo;
          this.sort();
        },
        setOrder: function(_order){
            this.order = _order;
        },
        getOrder: function(){
            return this.order;
        },
        getSortKey: function(){
            return this.sort_key;
        },
        findById:function(txt){
          var filtered = this.filter(function(item){
              return item.get('id') == txt;
          });
          return new TarjetasCollection(filtered);
        },
        findByIdCategoria:function(txt){
          var filtered = this.filter(function(item){
              //console.log(item.get('id_categoria')+" == "+txt);
              return item.get('id_categoria') == txt;
          });
          return new TarjetasCollection(filtered);
        },
        cloneAll: function(){
            var temp = new Array();
            var res = new TarjetasCollection();
            this.each(function(model, index, ref){
                temp.push(model.clone());
            });
            res.add(temp);
            return res;
        }
      }
 );
 

 var CategoriasCollection = Backbone.Collection.extend(
      {
        model:Categoria,
        sort_key: "id",
        order: 1,
        comparator: function(a,b){
            //return item.get(this.sort_key);
            if(this.sort_key == "id"){
                value1 = a.get(this.sort_key);
                value2 = b.get(this.sort_key);
            }else{
                value1 = a.get(this.sort_key).toLowerCase();
                value2 = b.get(this.sort_key).toLowerCase();
            }
            if (value1 < value2){
              ret = -1;
            }else if (value1 > value2){
                ret = 1;
            }else{
                ret = 0;
            }
            return this.order * ret;
        },
        sortByField: function(campo){
          this.sort_key = campo;
          this.sort();
        },
        setOrder: function(_order){
            this.order = _order;
        },
        getOrder: function(){
            return this.order;
        },
        getSortKey: function(){
            return this.sort_key;
        },
        findById:function(txt){
          var filtered = this.filter(function(item){
              return item.get('id') == txt;
          });
          return new CategoriasCollection(filtered);
        },
        cloneAll: function(){
            var temp = new Array();
            var res = new CategoriasCollection();
            this.each(function(model, index, ref){
                temp.push(model.clone());
            });
            res.add(temp);
            return res;
        }
      }
 );
 
 
 

 var UsersCollection = Backbone.Collection.extend(
      {
        model:User,
        sort_key: "id",
        order: 1,
        comparator: function(a,b){
            //return item.get(this.sort_key);
            value1 = a.get(this.sort_key).toLowerCase();
            value2 = b.get(this.sort_key).toLowerCase();
            if (value1 < value2){
              ret = -1;
            }else if (value1 > value2){
                ret = 1;
            }else{
                ret = 0;
            }
            return this.order * ret;
        },
        sortByField: function(campo){
          this.sort_key = campo;
          this.sort();
        },
        setOrder: function(_order){
            this.order = _order;
        },
        getOrder: function(){
            return this.order;
        },
        getSortKey: function(){
            return this.sort_key;
        },
        findById:function(txt){
          var filtered = this.filter(function(item){
              return item.get('id') == txt;
          });
          return new UsersCollection(filtered);
        },
        cloneAll: function(){
            var temp = new Array();
            var res = new UsersCollection();
            this.each(function(model, index, ref){
                temp.push(model.clone());
            });
            res.add(temp);
            return res;
        }
      }
 );