// mecánica básica del juego

var Game = Backbone.Model.extend(
    {
        defaults: {
            categorias:new CategoriasCollection(),
            tarjetas:new TarjetasCollection(),
            users:new UsersCollection(),
            historialTarjetas:new TarjetasCollection(),
            grabaDatos: true,
            partida: null,
            tarjetaActual:null,
            timestamp: null,
            date: null,
        },
        initialize: function(attr){
            if(!this.supports_html5_storage()) {
                creaAlerta("alerta", window.textos["a_localstore"][window.idioma], null, null);
                this.set("grabaDatos", false);
            }else{
                this.set("grabaDatos", true);
            }
        },
        setValues: function(_data){
        },
        processGlobalData: function(data){
            window.tarjetas = data.tarjetas;
            window.categorias = data.categorias;
            this.get("tarjetas").add(data.tarjetas);
            this.get("categorias").add(data.categorias);
            //pinto la mediateca
            window.pintaMediateca();
            window.pintaRecursos();
            //console.debug(this.get("tarjetas"));
            //console.debug(this.get("categorias"));
        },
        supports_html5_storage: function (){
            try {
                return 'localStorage' in window && window['localStorage'] !== null;
            } catch(e) {
                return false;
            }
        },
        getJSON: function(){
           var data = new Object();
           data.categorias = this.getJSONfromCollection(this.get("categorias"));
           data.tarjetas = this.getJSONfromCollection(this.get("tarjetas"));
           data.users = this.getJSONfromCollection(this.get("users"));
           data.historialTarjetas = this.getJSONfromCollection(this.get("historialTarjetas"));
           data.grabaDatos = this.get("grabaDatos");
           data.partida = this.get("partida").getJSON();
           if(this.get("tarjetaActual") != null){
                data.tarjetaActual = this.get("tarjetaActual").getJSON();
           }else{
                data.tarjetaActual = null;
           }
           data.timestamp = this.get("timestamp");
           data.date = this.get("date");
           return data;
        },
        getJSONfromCollection: function(collection){
            var _data = new Array();
            collection.each(function(model){
                _data.push(model.getJSON());
            });
            return _data;
        },
        saveJSON: function(){
            var hoy = new Date();
            if(this.get("timestamp") == null){
                this.set("timestamp", hoy.getTime());
                var mes = hoy.getMonth()+1;
                if(mes < 10){
                    mes = "0"+mes;
                }
                var dia = hoy.getDate()+1;
                if(dia < 10){
                    dia = "0"+dia;
                }
                this.set("date", hoy.getFullYear() + "/" + mes + "/" + dia);
            }
            
            var jsonData = this.getJSON();
            //console.debug(jsonData);
            var datos = localStorage.getItem("testearte_primaria");
            datos = JSON.parse(datos);
            if(datos === null || datos.toString() == ""){
                datos = new Array();
                datos.push(jsonData);
            }else{
                var existe = false;
                for(var i= 0; i<datos.length; i++){
                    if(jsonData.timestamp == datos[i].timestamp){
                        datos[i] = jsonData;
                        localStorage.setItem("testearte_primaria", JSON.stringify(datos));
                        window.creaAlerta("alerta", window.textos["a_savedOk"][window.idioma], null, null);
                        existe = true;
                        break;
                    }
                }
                if(!existe){
                    datos.push(jsonData);
                }
            }
            
            datos = JSON.stringify(datos);
            localStorage.setItem("testearte_primaria", datos);
            //console.debug(localStorage.getItem("testearte_primaria"));
            window.creaAlerta("alerta", window.textos["a_savedOk"][window.idioma], null, null);
        },
        addPlayer: function(nombre, avatar){
            this.get("users").add({nombre:nombre, color:avatar});
            //console.debug(this.get("users"));
        },
        deletePlayer: function(_id){
            $.game.get("users").remove($.game.get("users").get(_id));
            window.preenter_page_new();
        },
        setTestingData: function(_data){
            this.set("users", _data.users);
            this.set("partida", _data.partida);
        },
        loadSavedGame: function(_data){
            this.set("categorias", new CategoriasCollection(_data.categorias));
            this.set("tarjetas", new TarjetasCollection(_data.tarjetas));
            this.set("users", new UsersCollection(_data.users));
            this.set("historialTarjetas", new TarjetasCollection(_data.historialTarjetas));
            this.set("grabaDatos", _data.grabaDatos);
            this.set("partida", new Partida(_data.partida));
            this.set("tarjetaActual", new Tarjeta(_data.tarjetaActual));
            this.set("timestamp", _data.timestamp);
            this.set("date", _data.date);
        },
    }
);