/* 
 * Inicializacion del juego
 */
//grados a partir de los cuales parte la ruleta
var lastDegrees = 0;
//categoría de la próxima tarjeta que se muestre
var categoriaTarjeta;
//guarda la función que se ejecuta cuando se cierra la tarjeta (acierto o error)
var funcionCloseTarjeta;
//control para que no se duplique el lanzamiento de la ruleta
var ruletaPlaying = false;
//y control para que no se duplique la carga de tarjetas
var waitingCard = false;
//controla que es una tarjeta especial (blanca o negra): valores: blanco, negro, normal;
var tipoTarjeta = "normal";
//variables con las puntuaciones de acierto/fallo para los distintos tipos
var puntosAciertoNormal = 2;
var puntosFalloNormal = -2;
var puntosAciertoBlanco = 2;
var puntosFalloBlanco = -2;
var puntosAciertoNegro = 2;
var puntosFalloNegro = -2;
var puntosSumaAciertos = 0;

//puntos con los que se gana
var maxPuntos = 8;

var initAlertBlanco = false; // hace que se lance la alerta de blanco una sola vez
var initAlertNegro = false; // hace que se lance la alerta de negro una sola vez
var initBlancoMin = 6; // mínimo de preguntas hechas para poner una pregunta de repaso. 

//usuario seleccionado para la pregunta negra
var userNegro = null;

//actualización del avatar con los nuevos datos de usuario
function actualizaAvatar(avatar, item){
  //  console.log(item.get("color"));
    avatar.data("cid", avatar.cid);  
    if(item.get("puntos") <= maxPuntos){
        avatar.find("img").prop("src", "images/avatares/"+item.get("color")+"_"+item.get("status")+".png");
    }
    avatar.find(".userName").html(item.get("nombre"));
    avatar.find(".userPuntuacion").html(item.get("puntos") + " " + textos["a_points"][idioma]);
    avatar.css("visibility", "visible");
    avatar.data("cid", item.cid);
    item.set("avatar", avatar);
    
}
function actualizaAvatares(){
    var users = $.game.get("users");
    var avatares = $("#avatares ul");
    var i = 1;
    //console.debug(avatares);
    users.each(function(item){
        //var avatar = $(avatares.get(7-i));
        var avatar = $(avatares.find("li.av_"+i).get(0));
       // console.debug("li.av_"+i);
        actualizaAvatar(avatar, item);
        i++;
    });
    //console.log("---------------");
    for(i; i<=8; i++ ){
        //var avatar = $(avatares.get(7-i));
        var avatar = $(avatares.find("li.av_"+i).get(0));
        //console.debug("li.av_"+i);
        avatar.css("visibility", "hidden");
    }
}


/*
 * turnos
 */

function startTurno(){
    var data = $.game.get("partida").get("data");
    var turno = data.turno;
    var user = $.game.get("users").at(turno);
    //preparo la animación para ese usuario
    /***************   MODIFICACIONES ANDROID   ******************/
    if(!isAndroid){
        $("canvas").animate({opacity:"0"}, {duration:200, complete:function(){
                setTimeout(function(){
                    console.log("Fotograma: " + user.get("color")+"_"+user.get("status"));
                    window.playPuppet(user.get("color")+"_"+user.get("status"));
                }, 200);
                $("canvas").delay( 600 ).animate({opacity:"1"}, {duration:200, complete:function(){

                }});
        }});
    }else{
        $("canvas").show();
        window.playPuppet(user.get("color")+"_"+user.get("status"))
        context.clearRect(0, 0, canvas.width, canvas.height);
        canvas.width = canvas.width;
        stage.clear();
    }
    /*************************************************************/
    
    var offset = $("#canvas_dummy").offset();
    $("canvas").css("top", offset.top).css("left", offset.left);
   
    
    
    $("#nombrePpal").html(user.get("nombre"));
    $("#numPpal").html(user.get("puntos"));
}

function getNewRotation(){
    var aleatorio = Math.floor(Math.random()*8);
    rotation = -((aleatorio + 20)*45);
    lastDegrees += rotation;
    return -(lastDegrees/45)%8;
}

function lanzaRuleta(){
    if(!ruletaPlaying){
        ruletaPlaying = true;
        
        
        console.log("Lanzando ruleta");
        $("#logger").append("<br>"+"Lanzando ruleta");
        var sector = getNewRotation();
        if($.game.get("historialTarjetas").length < initBlancoMin){
            while ((sector == 1 && $.game.get("historialTarjetas").length == 0) || sector == 5) {
                sector = getNewRotation();
            }
        }
        categoriaTarjeta = getCategoria(sector);
        //sector = 1;
        
        if(sector == 5){
             /**************   parte blanco    ******************/
            tipoTarjeta = "blanco";
            
            var realLastDegrees = lastDegrees;
            var sector2 = getNewRotation();
            while (sector2 == 1 || sector2 == 5) {
                sector2 = getNewRotation();
            }
            categoriaTarjeta = getCategoria(sector2);
            lastDegrees = realLastDegrees;
            
            if(!initAlertBlanco){
                initAlertBlanco = true;
                setTimeout(function(){
                        creaAlertaInit(textos["a_initBlanco"][idioma], "images/cuadro_blanco.jpg");
                    }, 2000);
            }
            var tarjetas = $.game.get("historialTarjetas");
        }else if(sector == 1 ){
             /**************   parte negro    ******************/
            tipoTarjeta = "negro";
            
            var realLastDegrees = lastDegrees;
            var sector2 = getNewRotation();
            while (sector2 == 1 || sector2 == 5) {
                sector2 = getNewRotation();
            }
            categoriaTarjeta = getCategoria(sector2);
            lastDegrees = realLastDegrees;
            
            
            //lanzo la ventana de selección del otro usuario
            setTimeout(function(){
                selectOtherUser();
            }, 2000);
            
            if(!initAlertNegro){
                initAlertNegro = true;
                setTimeout(function(){
                        creaAlertaInit(textos["a_initNegro"][idioma], "images/cuadro_negro.jpg");
                    }, 2000);
            }
            
            if($.game.get("tarjetas").findByIdCategoria(categoriaTarjeta).length > 0){
                var tarjetas = $.game.get("tarjetas").findByIdCategoria(categoriaTarjeta);
            }else{
                console.log("Recargando tarjetas porque se acabaron");
                var tarjetas = $.game.get("historialTarjetas").findByIdCategoria(categoriaTarjeta);
            }
        }else{
            tipoTarjeta = "normal";
            if($.game.get("tarjetas").findByIdCategoria(categoriaTarjeta).length > 0){
                var tarjetas = $.game.get("tarjetas").findByIdCategoria(categoriaTarjeta);
            }else{
                console.log("Recargando tarjetas porque se acabaron");
                var tarjetas = $.game.get("historialTarjetas").findByIdCategoria(categoriaTarjeta);
            }
            
        }
        
        

        $('#ruleta').css({'-webkit-transform' : 'rotate('+ lastDegrees +'deg)',
                     '-moz-transform' : 'rotate('+ lastDegrees +'deg)',
                     '-ms-transform' : 'rotate('+ lastDegrees +'deg)',
                     'transform' : 'rotate('+ lastDegrees +'deg)'});
        playSound("ruletaSound");

        
        if(categoriaTarjeta > 0){
            var tope = tarjetas.length;
            console.debug(tarjetas);
            var _tarjeta = tarjetas.at(Math.floor(tope*Math.random()));
            
            var tarjeta = _tarjeta.clone();
            if(tipoTarjeta != "blanco"){
                $.game.get("historialTarjetas").add(tarjeta);
                $.game.get("tarjetas").remove(_tarjeta);
            }
            $.game.set("tarjetaActual", tarjeta);

            setTimeout(function (){
                abreTarjeta(tarjeta);
            }, 2500);

        }else{
            
            window.playingAvatar = false;
        }
        
    }
}
function getCategoria(sector){
    switch(sector){
            case 0:
                console.log("amarillo");
                return 9;
                break;
            case 1:
                console.log("negro");
                return -1;
                break;
            case 2:
                console.log("rojo");
                return 12;
                break;
            case 3:
                console.log("verde");
                return 13;
                break;
            case 4:
                console.log("morado");
                return 14;
                break;
            case 5:
                console.log("blanco");
                return -2;
                break;
            case 6:
                console.log("azul");
                return 10;
                break;
            case 7:
                console.log("magenta");
                return 11;
                break;
            default:
                console.log("otro");
                return -3;
                break;
        }
}

function abreTarjeta(tarjeta){
    //ejecuta el sonido de la categoría
    if(tipoTarjeta != "negro"){
        playSound("sonido_" + categoriaTarjeta + "_" + idioma);
    }
    
    //creación de la tarjeta
    var contenedor = '<div id="tarjeta" class="fondo_alerta">';
    contenedor += '<div id="ventana_tarjeta" class="alerta">';
    contenedor += '<div id="containerImagen_tarjeta" >';
    contenedor += '<img id="foto_tarjeta" src="">';
    contenedor += '</div>';
    contenedor += '<div id="containerText_tarjeta" >';
    contenedor += '<div id="descripcion_tarjeta"></div>';
    contenedor += '<div id="pregunta_tarjeta"></div>';
    contenedor += '<div id="contenedor_respuestas">';
    contenedor += '<div id="respuesta1_tarjeta" class="respuesta" data-ref="1"></div>';
    contenedor += '<div id="respuesta2_tarjeta" class="respuesta" data-ref="2"></div>';
    contenedor += '<div id="respuesta3_tarjeta" class="respuesta" data-ref="3"></div>';
    contenedor += '</div>';
    contenedor += '</div>';
    contenedor += '<div id="enlace_tarjeta" class="boton_normal"><a><i class="fa fa-info fa-2x"></i></a></div>';
    contenedor += '<div id="enlace_recurso" class="boton_normal"><a><i class="fa fa-child fa-2x" aria-hidden="true"></i></a></div>';
    

    contenedor += '</div>';
    contenedor += '</div>';
    contenedor = $(contenedor);
    
    //pasando los datos a la tarjeta
    var _url = "http://contanimacion.com/testearte/web/imagenes/big/"+tarjeta.get("imagen");
    if(local){
        _url = "images/imagenes_tarjetas/big/"+tarjeta.get("imagen");
    }
    contenedor.find("#foto_tarjeta").prop("src", _url)
            .click(function(){
                abreFotoGrande($(this).prop("src"));
            });
    contenedor.find("#enlace_tarjeta a").prop("href", tarjeta.get("enlace"))
                .prop("target", "_blank");
    //console.debug(tarjeta);
    if(tarjeta.get("recursos")){
        contenedor.find("#enlace_recurso a").prop("href", tarjeta.get("recursos"))
                .prop("target", "_blank");
    }else{
        contenedor.find("#enlace_recurso").css("display", "none");
    }
    
    //contenedor.find("#piefoto_tarjeta").html(tarjeta.get("origen"));
    contenedor.find("#descripcion_tarjeta").html(tarjeta.get("descripcion"));
    contenedor.find("#pregunta_tarjeta").html(tarjeta.get("pregunta"));
    contenedor.find("#respuesta1_tarjeta").html(tarjeta.get("respuesta1"));
    contenedor.find("#respuesta2_tarjeta").html(tarjeta.get("respuesta2"));
    contenedor.find("#respuesta3_tarjeta").html(tarjeta.get("respuesta3"));
    contenedor.find("#tarjeta").css("display", "block");
    
    //precarga de la imagen y cuando está listo, muestra de la tarjeta
    var imagen = new Image();
    imagen.onload = function () {
        if(imagen.width >= imagen.height ){
            contenedor.addClass("horizontal");
            contenedor.find("#foto_tarjeta").removeClass("vertical");
        }if(imagen.height / imagen.width < 1.2){
            contenedor.addClass("horizontal");
            contenedor.find("#foto_tarjeta").addClass("vertical");
        }else{
            contenedor.addClass("vertical");
            contenedor.find("#foto_tarjeta").removeClass("vertical");
        }
        $("body").append(contenedor);
        contenedor.css({display: "block", opacity: 0})
                .animate({opacity: 1}, {duration: 500});
    }
    var _url2 = "http://contanimacion.com/testearte/web/imagenes/big/"+tarjeta.get("imagen");
    if(local){
        _url2 = "images/imagenes_tarjetas/big/"+tarjeta.get("imagen");
    }
    imagen.src = _url2;
    
    //pulsación de respuestas
    //respuesta_ok
    contenedor.find(".respuesta").click(function(event){
        playSound("pop");
        var boton = $(this);
        contenedor.find(".respuesta").each(function(){
            if($(this).data("ref") == $.game.get("tarjetaActual").get("respuesta_ok")){
               $(this).css("border-color", "rgba(0, 255, 0, 1)");
            }else{
                $(this).css("border-color", "#FF0000");
            }
            $(this).css("border-width", "6px");
        });
        if($(this).data("ref") == $.game.get("tarjetaActual").get("respuesta_ok")){
            contenedor.find("#ventana_tarjeta").append('<div id="result"><i class="fa fa-check fa-6x"></i></div>');
            funcionCloseTarjeta = setAcierto;
            playSound("aplauso");
        }else{
            contenedor.find("#ventana_tarjeta").append('<div id="result"><i class="fa fa-times fa-6x"></i></div>');
            funcionCloseTarjeta = setFallo;
            playSound("risa");
        }
        event.stopPropagation();
        contenedor.click(function(event){
            playSound("pop");
            contenedor.animate({opacity:0}, {duration:500, complete:function(){
                   contenedor.remove(); 
                   funcionCloseTarjeta();
            }});
            event.stopPropagation();
        });
        contenedor.css("cursor", "pointer");
    });
    
    console.debug(contenedor);
}

function setAcierto(){
    var data = $.game.get("partida").get("data");
    var turno = data.turno;
    var user = $.game.get("users").at(turno);
    var creaEfecto = false;
    if(tipoTarjeta == "normal"){
        user.set("status", user.get("status") + 1);
        user.set("puntos", user.get("puntos") + puntosAciertoNormal + user.get("puntosAcierto"));
        creaEfecto = true;
    }else if(tipoTarjeta == "blanco"){
        user.set("status", user.get("status") + 1);
        user.set("puntos", user.get("puntos") + puntosAciertoBlanco);
        creaEfecto = true;
    }else if(tipoTarjeta == "negro"){
        userNegro.set("status", userNegro.get("status") + 1);
        userNegro.set("puntos", userNegro.get("puntos") + puntosAciertoNegro);
        if(userNegro.get("status") >= maxPuntos){
            finJuego(userNegro);
            return;
         }
    }
    user.set("puntosAcierto", user.get("puntosAcierto") + puntosSumaAciertos);
    
    if(user.get("puntos") > maxPuntos){
       finJuego(user);
    }else{
        avanzaTurno(data, user, turno, creaEfecto);
    }
    
}
function setFallo(){
    var data = $.game.get("partida").get("data");
    var turno = data.turno;
    var user = $.game.get("users").at(turno);
    var creaEfecto = false;
    user.set("puntosAcierto", 0);
    if(tipoTarjeta == "normal"){
        console.log("llega un fallo normal");
        if(user.get("puntos") > 0){
            user.set("status", user.get("status") - 1);
            user.set("puntos", user.get("puntos") + puntosFalloNormal);
            creaEfecto = true;
        }
    }else if(tipoTarjeta == "blanco"){
        if(user.get("puntos") > 0){
            user.set("status", user.get("status") - 1);
            user.set("puntos", user.get("puntos") + puntosFalloBlanco);
            creaEfecto = true;
        }
    }else if(tipoTarjeta == "negro"){
        if(userNegro.get("puntos") > 0){
            userNegro.set("status", userNegro.get("status") - 1);
            userNegro.set("puntos", userNegro.get("puntos") + puntosFalloNegro);
            if(userNegro.get("puntos") < 0){
                userNegro.set("puntos", 0);
            }
        }
    }
    if(user.get("puntos") < 0){
        user.set("puntos", 0);
    }
    avanzaTurno(data, user, turno, creaEfecto);
}
function avanzaTurno(data, user, turno, creaEfecto){
    waitingCard = false;
    if(creaEfecto){
        window.createEffect(user.get("color")+"_"+user.get("status"));
    }
    setTimeout(function(){
        actualizaAvatares();
    
        data.turno = data.turno + 1;
        if(data.turno >= $.game.get("users").length){
            data.turno = 0;
        }
        $.game.get("partida").set("data", data);
        
        //devuelvo la posibilidad de lanzar la ruleta (en este momento está ya tapada por la tarjeta
        ruletaPlaying = false;
        
        startTurno();
    }, 3000);
    
}


//alerta para mostrar el selector de usuarios para el color negro
function selectOtherUser(){
    var _div = '<div id="selector_usuarios" class="fondo_alerta"><div class="alerta">';
    _div += '<p class="alerta_rotulo">'+textos["a_selectUserBlack"][idioma]+'</p>';
    _div += '<div class="contenedor_avatares_total">';
    _div += '<div class="contenedor_avatares">';
    _div += '<div class="avatar avatar_oculto" data-ref="avatar_1"></div>';
    _div += '<div class="avatar avatar_oculto" data-ref="avatar_2"></div>';
    _div += '<div class="avatar avatar_oculto" data-ref="avatar_3"></div>';
    _div += '<div class="avatar avatar_oculto" data-ref="avatar_4"></div>';
    _div += '</div>';
    _div += '<div class="contenedor_avatares">';
    _div += '<div class="avatar avatar_oculto" data-ref="avatar_5"></div>';
    _div += '<div class="avatar avatar_oculto" data-ref="avatar_6"></div>';
    _div += '<div class="avatar avatar_oculto" data-ref="avatar_7"></div>';
    _div += '<div class="avatar avatar_oculto" data-ref="avatar_8"></div>';
    _div += '</div>';
    _div += '</div>';
    _div += '</div></div>';
    var div = $(_div);
    
    var users = $.game.get("users");
    var avatares = div.find(".avatar");
    var data = $.game.get("partida").get("data");
    var turno = data.turno;
    var user = $.game.get("users").at(turno);
    var indice = 0;
    for(var i=0; i<users.length; i++){
        var _user = users.at(i);
        if(user.cid != _user.cid || users.length == 1){
            $(avatares.get(i)).data("ref", _user.cid)
            .addClass(_user.get("color"))
            .removeClass("avatar_oculto");
            indice ++;
        }
    }
    
    div.css("opacity", 0);
    $("body").append(div);
    div.find(".avatar:not(.avatar_oculto)").click(function(){
        //ejecuta el sonido de la categoría
        playSound("sonido_" + categoriaTarjeta + "_" + idioma);
        
        var users = $.game.get("users");
        userNegro = users.get($(this).data("ref"));
        div.remove();
    })
    div.animate({opacity: 1}, {duration: 500});
}


// final del juego
function finJuego(user){
    //pongo el valor 1 en el muñeco
    actualizaAvatares();
    //console.log(user.get("color") + "_5_win");
    //window.root.gotoAndStop(user.get("color") + "_" + user.get("status") + "_win");
   
    waitingCard = false;
    creaAlertaFin(user.get("puntos"), user.get("color")+"B", user.get("color"));
    
        $.game = new Game();
        $.game.get("tarjetas").add(tarjetas);
        $.game.get("categorias").add(categorias);
        $.game.set("historialTarjetas", new TarjetasCollection());
        
     //window.root.gotoAndStop("avatar_1_5_win");
     window.root.gotoAndStop(user.get("color") + "_5_win");
     ruletaPlaying = false;
}



//alerta del final del juego
function creaAlertaFin(puntos, refCanvas, avatar){
    var _div = '<div id="alertaFinal" class="fondo_alerta"><div id="alertaInit" class="alerta">';
    _div += '<p class="alerta_rotulo"><span class="win">'+textos["a_winRotulo"][idioma]+'</p>';
    _div += '<div id="canvasWin"></div>';
    _div += '<div class="bottom_buttonbar">';
    _div += '<a class="b_cancel boton_normal boton_texto boton_central">'+textos["b_aceptar"][idioma]+'</a>';
    _div += '</div>';
    _div += '</div></div>';
    var div = $(_div);
    div.find(".b_cancel").click(function(){
        window.hideAll();
         window.root.gotoAndStop(0);
         $("canvas").hide();
         $("#main_wrapper").simpleHorizontalNavigator("gotoPage", "home", null, null);
          var canvas = $("canvas");
          canvas.css({position:"absolute"});
          $("body").append(canvas);
         div.remove();
    })
    div.css("opacity", 0);
    //preparo la animación
    var canvas = $("canvas");
    canvas.css({position:"inherit"});
    div.find("#canvasWin").append(canvas);
    window.refWin = refCanvas;
    //console.log("Enviando el cabezal a " + avatar + "_win");
    window.playWin(avatar + "_4_win");
    
    $("body").append(div);
    div.animate({opacity: 1}, {duration: 500});
}


function abreFotoGrande(ruta){
    var _div = '<div id="fotoGrande" class="fondo_alerta"><img src="'+ruta+'"></div>';
    var div = $(_div);
    var imagen = new Image();
    $("body").append(div);
    div.click(function(){
        div.remove();
    });
}

