/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

//localStorage.clear();

var $;
//variables de la aplicación
var idioma; //idioma de la app (es, ga, en)
var initAlertLaunched = false; // hace que se lance la alerta de apretar al muñeco una sola vez
var id_juego = 3; //id del juego
var context 

var ua = navigator.userAgent.toLowerCase();
var isAndroid = ua.indexOf("android") > -1; //&& ua.indexOf("mobile");

var textos = null; //objeto con todos los textos

//control de si se juega con o sin red
var local = false;
var loc_str = String(window.location);
if(loc_str.indexOf("file://") >= 0 || (loc_str.indexOf("localhost") == -1 && loc_str.indexOf("contanimacion") == -1)){
    local = true;
    console.log("Cargando juego con datos en LOCAL");
}else{
    console.log("Cargando juego con datos en REMOTO");
}

/*
 * preparo el canvas
 */
var canvas, stage, exportRoot;

function init() {
    
    loadAudios();

	canvas = document.getElementById("canvas");
        context = canvas.getContext('2d');
        
	exportRoot = new lib.animacion();
        
        stage = new createjs.Stage(canvas);
        stage.addChild(exportRoot);
        stage.update();

        createjs.Ticker.setFPS(lib.properties.fps);
        createjs.Ticker.addEventListener("tick", stage);
        
        
        $("canvas").hide();
}



/*
 * y comienzo el jquery
 */
jQuery(document).ready(function(_$) {
    //añadimos el crossdomain para IE
    jQuery.support.cors = true;
    // cargo los textos multilingues
    pideTextos();
        


    //lanzo el sistema de animaciones
    init();
    
    //corrige el problema de duplicar el canvas en android
    $("canvas").parents("*").css("overflow", "visible");
    
    
    $ = _$;
    
    //creando el sistema de navegación
    $("#main_wrapper").simpleHorizontalNavigator({
        pagesInit:[{id:"select_languaje", level:0},
                {id:"home", level:1}, 
                {id:"new_game", level:2}, 
                {id:"new_player", level:3},
                {id:"select_game", level:2}, 
                {id:"game", level:3}, 
                {id:"help", level:4}],
        easing:"easeInOutCubic",
    });
    
    //cargamos las páginas
    init_page_languaje();
    init_page_home();
    init_page_new();
    init_page_newPlayer();
    init_page_select();
    init_page_game();
    init_page_ayuda();
    
    //aplica el sonido a los botones
    $(".b_idioma, .boton_normal").click(function(){
        playSound("pop");
    });
});



function pideTextos(){
    var obj = {
    "textos": {
        "b_newP":{
            "es":"nueva partida",
            "ga":"novo xogo",
            "en":"new game"
        },
        "b_savedP":{
            "es":"partida guardada",
            "ga":"partida gardada",
            "en":"saved games"
        },
        "b_resultsP":{
            "es":"puntuaciones",
            "ga":"puntuacións",
            "en":"scores"
        },
        "b_helpP":{
            "es":"ayuda",
            "ga":"axuda",
            "en":"help"
        },
        
        
        
        
        "l_new":{
            "es":"Nueva partida",
            "ga":"Nova partida",
            "en":"New game"
        },
        "l_centro":{
            "es":"Nombre del centro",
            "ga":"Nome do centro",
            "en":"School name"
        },
        "l_grupo":{
            "es":"Grupo",
            "ga":"Grupo",
            "en":"Group"
        },
        "l_players":{
            "es":"Jugadores",
            "ga":"Xogadores",
            "en":"Players"
        },
        "b_play_new":{
            "es":"Jugar",
            "ga":"Xogar",
            "en":"Play"
        },
        
        
        
        
        
        "l_newPlayer":{
            "es":"Nuevo jugador",
            "ga":"Novo xogador",
            "en":"New player"
        },
        "l_namePlayer":{
            "es":"Nombre",
            "ga":"Nome",
            "en":"Name"
        },
        "b_savePlayer":{
            "es":"Guardar",
            "ga":"Gardar",
            "en":"Save"
        },
        
        
        
        
        
        "l_savedGames":{
            "es":"Partidas guardadas",
            "ga":"Partidas gardadas",
            "en":"Saved games"
        },
        
        
        
        
        
        
        "l_playerPoints":{
            "es":"puntos",
            "ga":"puntos",
            "en":"points"
        },
        "b_saveGame":{
            "es":"Guardar",
            "ga":"Gardar",
            "en":"Save"
        },
        
        
        
        
        
        
        
        "l_help":{
            "es":"Ayuda",
            "ga":"Axuda",
            "en":"Help"
        },
        "p_help0":{
            "es":"Objetivo",
            "ga":"Obxectivo",
            "en":"Aim of the game"
        },
        "p_help1":{
            "es":"Consigue que tu avatar se haga mayor y llegue a los 10 puntos demostrando lo mucho que sabes sobre arte",
            "ga":"Fai crecer o teu avatar e consegue 10 puntos amosando o moito que sabes sobre arte",
            "en":"Get your avatar to reach maturity achieving 10 points"
        },
        "p_help2":{
            "es":"Preguntas",
            "ga":"Preguntas",
            "en":"Questions"
        },
        "p_help3":{
            "es":"Las preguntas pertenecen a las siguientes categorías definidas por su color:",
            "ga":"As preguntas pertencen ás seguintes categorías definidas pola súa cor:",
            "en":"The questions fall into the following categories defined by a color:"
        },
        "p_help4":{
            "es":"Color",
            "ga":"Cor",
            "en":"Color"
        },
        "p_help5":{
            "es":"Volumen",
            "ga":"Volume",
            "en":"Volume"
        },
        "p_help6":{
            "es":"Textura",
            "ga":"Textura",
            "en":"Texture"
        },
        "p_help7":{
            "es":"Mensaje visual",
            "ga":"Mensaxe visual",
            "en":"Visual message"
        },
        "p_help8":{
            "es":"Forma",
            "ga":"Forma",
            "en":"Shape"
        },
        "p_help9":{
            "es":"Técnica",
            "ga":"Técnica",
            "en":"Technique"
        },
        "p_help10":{
            "es":"Rebote: la pregunta y los puntos correspondientes pasan al avatar que tú elijas",
            "ga":"Rebote: a pregunta e os puntos correspondentes pasan ao avatar que ti elixas",
            "en":"Rebound: the question and the corresponding points will go onto a diferent avatar you choose"
        },
        "p_help11":{
            "es":"Repaso: la pregunta es una de las vistas",
            "ga":"Repaso: a pregunta é unha das vistas",
            "en":"Review: the question is one of previous questions"
        },
        "p_help12":{
            "es":"Partida",
            "ga":"Partida",
            "en":"Game"
        },
        "p_help13":{
            "es":"Mecánica del juego:",
            "ga":"Mecánica do xogo",
            "en":"Game mechanics:"
        },
        "p_help14":{
            "es":"En cada turno se hace clic sobre el avatar para que haga girar la ruleta y se seleccione aleatoriamente una tarjeta<br>Haciendo clic sobre la imagen de la tarjeta se amplía ocupando el máximo espacio<br>Pulsando sobre el botón de info de la tarjeta se amplía la información sobre el tema<br>Pulsando sobre el botón con el icono humano se abre un nuevo recurso para el profesor<br>Tras contestar una de las tres opciones pasa el turno al siguiente jugador",
            "ga":"En cada quenda faise clic sobre o avatar para que faga xirar a ruleta e se seleccione aleatoriamente unha tarxeta<br>Facendo clic sobre a imaxe amplíase ocupando o máximo espazo<br>Pulsando no botón de información da tarxeta amplíase a información sobre o tema<br>Pulsando no botón da icona humana, ábrese un novo recurso para o profesor<br>Tras contestar unha das tres opcións pasa a quenda ao seguinte xogador",
            "en":"Each turn is clicked on the avatar to spin the wheel and randomly select a card<br>Clicking on the image, it will be enlarged over the maximum space<br> Clicking on the info button of the card you will receive more information<br>Clicking on the human icon button you will access to a new resource<br>After answering one of the three options it will spin onto the next player"
        },
        "p_help15":{
            "es":"Puntuaciones:",
            "ga":"Puntuacións:",
            "en":"Scores:"
        },
        "p_help16":{
            "es":"- Tarjeta normal: acierto +2 puntos, fallo -2 puntos<br>- Rebote: acierto +2 puntos, fallo -2 puntos. Puntos asignados al jugador que contesta<br>- Repaso: acierto +2 puntos, fallo -2 puntos",
            "ga":"- Tarxeta normal: acerto +2 puntos, fallo -2 puntos<br >- Rebote: acerto +2 puntos, fallo -2 puntos.  Puntos asignados ao xogador que contesta<br >- Repaso: acerto +2 puntos, fallo -2 puntos",
            "en":"- Normal card: hit +2 points, failure -2 points<br> - Rebound: hit +2 points, failure -2 points. They are assigned to the player who answers<br>- Review: hit +2 points, failure -2 points"
        },
        "p_help17":{
            "es":"Guardar partida:",
            "ga":"Gardar partida",
            "en":"Save game:"
        },
        "p_help18":{
            "es":"La partida se guarda en el navegador utilizado y se podrá recuperar jugando en ese mismo navegador, entrando en el apartado de partidas guardadas",
            "ga":"A partida gárdase no navegador utilizado e poderase recuperar xogando nese mesmo navegador, entrando no apartado de partidas gardadas",
            "en":"The game is saved in the browser and can be used to recover playing in the same browser, entering the section saved games"
        },
        
        "p_help19":{
            "es":"Webteca",
            "ga":"Webteca",
            "en":"Library links"
        },
        "p_help20":{
            "es":"Créditos",
            "ga":"Créditos",
            "en":"Credits"
        },
        "p_help21":{
            "es":"Juego elaborado por <a href='mailto:cgtrece@yahoo.es'>Cristina G. Treceño</a> con una licencia retribuída por la Consejería de Cultura, Educación y Ordenación Universitaria de la Xunta de Galicia 2016<br><span class='colaboracion'>Con la colaboración de <a href='mailto:info@contanimacion.com'>Jorge G. Villanueva</a> y Liselotte Rademaker</span><br><a class='logo_licencia' href='https://creativecommons.org/licenses/by-sa/4.0/deed.es_ES' target='licencia'><img src='http://mirrors.creativecommons.org/presskit/buttons/88x31/png/by-sa.png' /></a >",
            "ga":"Xogo elaborado por <a href='mailto:cgtrece@yahoo.es'>Cristina G. Treceño</a> cunha licenza retribuída pola Consellería de Cultura, Educación e Ordenación Universitaria da Xunta de Galicia 2016<br><span class='colaboracion'>Coa colaboración de <a href='mailto:info@contanimacion.com'>Jorge G. Villanueva</a> e Liselotte Rademaker</span><br><a class='logo_licencia' href='https://creativecommons.org/licenses/by-sa/4.0/deed.gl' target='licencia'><img src='http://mirrors.creativecommons.org/presskit/buttons/88x31/png/by-sa.png' /></a >",
            "en":"Game developed by <a href='mailto:cgtrece@yahoo.es'>Cristina G. Treceño</a> with a paid licensed by the Ministry of Culture, Education and University Planning of the Xunta of Galicia 2016<br><span class='colaboracion'>With the collaboration of <a href='mailto:info@contanimacion.com'>Jorge G. Villanueva</a> and Liselotte Rademaker</span><br><a class='logo_licencia' href='https://creativecommons.org/licenses/by-sa/4.0/' target='licencia'><img src='http://mirrors.creativecommons.org/presskit/buttons/88x31/png/by-sa.png' /></a >"
        },
        "p_help22":{
            "es":"Recursos",
            "ga":"Recursos",
            "en":"Resources"
        },
        
        
        
        
        
        
        
        "l_best":{
            "es":"Mejores puntuaciones",
            "ga":"Mellores puntuacións",
            "en":"Highest scores"
        },
        
        
        
        
        
        
        "a_oneplayer":{
            "es":"Para jugar es necesario añadir al menos un jugador",
            "ga":"Para xogar é necesario engadir polo menos un xogador",
            "en":"To play you need to add at least one player"
        },
        "b_addplayer":{
            "es":"añadir jugador",
            "ga":"engadir xogador",
            "en":"add player"
        },
        "a_deletePlayes":{
            "es":"¿Seguro que quieres borrar el usuario?",
            "ga":"Seguro que queres borrar o usuario?",
            "en":"Are you sure you want to delete the user?"
        },
        "a_needName":{
            "es":"Debes escribir un nombre",
            "ga":"Debes escribir un nome",
            "en":"You must enter a name"
        },
        "a_needAvatar":{
            "es":"Debes seleccionar un avatar",
            "ga":"Debes seleccionar un avatar",
            "en":"You must select an avatar"
        },
        "a_quitGame":{
            "es":"¿Seguro que quieres abandonar la partida?",
            "ga":"Seguro que queres abandonar a partida?",
            "en":"Are you sure you want to leave the game?"
        },
        "a_initGame":{
            "es":"Para comenzar tu turno tienes que hacer clic sobre tu avatar en la ruleta",
            "ga":"Para comezar a túa quenda tes que facer clic sobre o teu avatar na ruleta",
            "en":"To begin your turn, you have to click on your avatar on the roulette wheel"
        },
        "b_aceptar":{
            "es":"Aceptar",
            "ga":"Aceptar",
            "en":"Ok"
        },
        "b_cancelar":{
            "es":"Cancelar",
            "ga":"Cancelar",
            "en":"Cancel"
        },
        "a_deleteGame":{
            "es":"¿Seguro que quieres borrar la partida?",
            "ga":"Seguro que queres borrar a partida?",
            "en":"Are you sure you want to delete the game?"
        },
        
        
        
        
        
        
        
        "a_initBlanco":{
            "es":"El color blanco significa que es una pregunta de repaso",
            "ga":"A cor branca significa que é unha pregunta de repaso",
            "en":"The white color means it is a review question"
        },
        "a_initNegro":{
            "es":"El color negro significa que se pasa la pregunta y la puntuación correspondiente al usuario que se seleccione",
            "ga":"A cor negra significa que se pasa a pregunta e a puntuación correspondente ao usuario que se seleccione",
            "en":"The black color means that the question and the related score goes to the user  that you selected previously"
        },
        "a_selectUserBlack":{
            "es":"Selecciona el usuario al que quieres pasar la pregunta",
            "ga":"Selecciona o usuario ao que queres pasar a pregunta",
            "en":"Select the user you would like to answer the question"
        },
        "a_winRotulo":{
            "es":"¡Enhorabuena!</span><br>Has ganado la partida",
            "ga":"Parabéns!</span><br>Gañaches a partida",
            "en":"Congratulations! </ span> <br> You have won the game "
        },
        "a_points":{
            "es":"puntos",
            "ga":"puntos",
            "en":"points"
        },
        
        
        
        
        
        
        "a_localstore":{
            "es":"Tu navegador no admite guardar los datos de partida",
            "ga":"O teu navegador non admite gardar os datos de partida",
            "en":"Your browser does not support saving the input data"
        },
        "a_savedOk":{
            "es":"Datos guardados correctamente",
            "ga":"Datos gardados correctamente",
            "en":"Data saved correctly"
        }
    }
}
textos = obj.textos;
$("#page_wrapper").css("display", "block");
/*
    var obj = {
                type: "GET",
                url: "js/textos.txt",
                dataType: "json",
                ContentType : "application/json",
                data: {}
            }
    $.ajax(obj)
        .done(function( msg ) {
            console.log(msg.textos);
            console.log( "Recibidos los textos traducidos");
            textos = msg.textos;
            console.log(textos);
            $("#page_wrapper").css("display", "block");
            alert(msg.textos.a_deleteGame.es);
        })
        .fail(function( jqXHR, textStatus ) {
            console.log( "Text request failed: " + textStatus );  
            //console.debug( jqXHR );  
        });*/
}





/*
 * página selección de idioma
 */
function init_page_languaje(){
    $(".b_idioma").click(function(){
        idioma = $(this).data("idioma");
        loadData();
        cargaTextos();
    });
}
//carga de datos de la aplicación
function loadData(){
    var _url = "http://www.contanimacion.com/testearte/web/Tarjeta/getall/"+id_juego+"/"+idioma;
    if(local){
        _url = "js/tarjetas_" + idioma + ".json";
    }
    
    $("body").simpleDistractor({});
    $.game = new Game();
    var obj = {
                type: "POST",
                url: _url,
                crossDomain : true,
                dataType: "json",
                data: {}
            }
    $.ajax(obj)
        .done(function( msg ) {
            console.log( "Recibidos los datos");
            //console.debug( msg );
            $.game.processGlobalData(msg);
            $("body").simpleDistractor("destroy");
            $("#main_wrapper").simpleHorizontalNavigator("gotoPage", "home", preenter_page_home, enter_page_home);
            
        })
        .fail(function( jqXHR, textStatus ) {
            console.log( "Data request failed: " + textStatus );  
            console.log( jqXHR.status );  
            console.log( jqXHR.statusText );  
            console.log( jqXHR.statusCode() );  
            console.log( jqXHR.responseText );  
        });
}




/*
 * página home de entrada
 */
function init_page_home(){
    $("#home .b_new").click(function(){
        $.game.set("users", new UsersCollection());
            
        $("#main_wrapper").simpleHorizontalNavigator("gotoPage", "new_game", preenter_page_new, null);
    });
    $("#home .b_select").click(function(){
        $("#main_wrapper").simpleHorizontalNavigator("gotoPage", "select_game", preenter_page_select, null);
    });
    $("#home .b_puntuacion").click(function(){
        $("#main_wrapper").simpleHorizontalNavigator("gotoPage", "results", preenter_page_resultados, null);
    });
    $("#home .b_help").click(function(){
        $("#main_wrapper").simpleHorizontalNavigator("gotoPage", "help", null, null);
    });
    
    
    
    
    $("#home .b_new, #home .b_select, #home .b_puntuacion, #home .b_help").find(".boton_normal_info").fadeOut(0);
    $("#home .b_new, #home .b_select, #home .b_puntuacion, #home .b_help").mouseenter(function(){
        $(this).find(".boton_normal_info").fadeIn(600);
    });
    $("#home .b_new, #home .b_select, #home .b_puntuacion, #home .b_help").mouseleave(function(){
        $(this).find(".boton_normal_info").fadeOut(200);
    });
}
function preenter_page_home(){
    console.log("preparando la página home");
    
}
function enter_page_home(){
    console.log("entrando en la página home");
    
   //cargaPartidaFalsa();
}
function cargaPartidaFalsa(){
    console.log("cargo datos falsos para pruebas de juego");
    var data = new Object();
    data.users = new UsersCollection([{nombre:"Jorge", color:"avatar_2"},{nombre:"Cristina", color:"avatar_5"}]);
    data.partida = new Partida({id_juego:id_juego, centro:"C.P.I. Ribeira", clase:"1ºC"});
    $.game.setTestingData(data);
    $("#main_wrapper").simpleHorizontalNavigator("gotoPage", "game", preenter_page_game, loaded_page_game);
}




/*
 * página de nueva partida
 */
function init_page_new(){
    $("#new_game .b_home").click(function(){
        $("#main_wrapper").simpleHorizontalNavigator("gotoPage", "home", null, null);
    });
    $("#new_game .b_play").click(function(){
        if($.game.get("users").length == 0){
            creaAlerta("alerta", textos["a_oneplayer"][idioma], null, null);
        }else{
            $.game.set("partida", new Partida({"centro": $("#centro").val(),
                                                                "clase": $("#grupo").val(),
                                                                "id_juego": id_juego}));
            $("#main_wrapper").simpleHorizontalNavigator("gotoPage", "game", preenter_page_game, loaded_page_game);
        }
    });
    $("#centro, #grupo").val("").keyup(function(event){
        var code = event.keyCode || event.which;
        if(code == 13){
            $(':focus').blur()
        }
    });
}
function preenter_page_new(){
    var _bloque0 = '<div class="form_bloque_element b_newPlayer_container">';
    _bloque0 += '<a class="b_newPlayer boton_normal"><i class="fa fa-plus fa-2x"></i>';
    _bloque0 += '<div class="">'+textos["b_addplayer"][idioma]+'</div></a></div>';
    var bloque0 = $(_bloque0);
    bloque0.find(".b_newPlayer").click(function(){
        playSound("pop");
        $("#main_wrapper").simpleHorizontalNavigator("gotoPage", "new_player", preenter_new_player, null);
    });
    
    
    
    $("#new_game .form_bloque").html("<div class='user_container'></div>");
    $.game.get("users").each(function(user){
        var userBloq = '<div class="form_bloque_element form_user" data-id="' + user.cid + '"><img src="images/avatares/' + user.get("color") + '.png">';
        userBloq += '<input name="player' + user.cid + '" id="player' + user.cid + '" value="' + user.get("nombre") + '" readonly/></div>';
                                
        $("#new_game .form_bloque .user_container").append(userBloq);
    });
    if($.game.get("users").length < 8){
        $("#new_game .form_bloque .user_container").append(bloque0);
    }
    
    $(".form_bloque_element.form_user").click(function(){
        creaAlerta("prompt", textos["a_deletePlayes"][idioma], $.game.deletePlayer, $(this).data("id"));
    });
}
function addPlayer(){
  var nombre = $("#nombre_usuario").val();
  var avatar =  window.avatar_temp;
  if(nombre == "" ){
      creaAlerta("alerta", textos["a_needName"][idioma], null, null);
      return false;
  }
  if(avatar == undefined ){
      creaAlerta("alerta", textos["a_needAvatar"][idioma], null, null);
      return false;
  }
  $.game.addPlayer(nombre, avatar);
  $("#main_wrapper").simpleHorizontalNavigator("gotoPage", "new_game", preenter_page_new, null);
};


/*
 * página de creación de usuarios
 */
function init_page_newPlayer(){
    $("#new_player .b_new").click(function(){
        $("#main_wrapper").simpleHorizontalNavigator("gotoPage", "new_game", preenter_page_new, null);
    });
    $("#nombre_usuario").val("").keyup(function(event){
        var code = event.keyCode || event.which;
        if(code == 13){
            $(':focus').blur()
            $(".b_addPlayer").trigger( "click" );
        }
    });
    
    
    $(".avatar").click(function(){
        $(".avatar").removeClass("activo");
        $(this).addClass("activo");
        window.avatar_temp = $(this).data("ref");
    });
    $(".b_addPlayer").click(function(){
        addPlayer();
    })
}
function preenter_new_player(){
    $("#nombre_usuario").val("");
    $(".avatar").removeClass("activo");
    window.avatar_temp = undefined;
}





/*
 * página selección de juego guardado
 */
function init_page_select(){
    $("#select_game .b_home").click(function(){
        $("#main_wrapper").simpleHorizontalNavigator("gotoPage", "home", null, null);
    });
    $("#select_game .b_play").click(function(){
        $("#main_wrapper").simpleHorizontalNavigator("gotoPage", "game", preenter_page_game, loaded_page_game);
    });
    
    
}
function preenter_page_select(){
     $("#lista_partidas ul").html("")
     var datos = localStorage.getItem("testearte_primaria");
     if(datos != null){
         datos = JSON.parse(datos);
     }else{
         datos = new Array();
     }
      $("#select_game .lista_partidas ul").html("");
     for(var i=0; i<datos.length; i++){
        var li = "<li data-ref='" + i + "'><span class='centro'><span class='cuadro'></span>" + datos[i].partida.centro + "</span><span class='fecha'>" + datos[i].partida.clase + " - " + datos[i].date + "</span><i class='fa fa-trash'></i></li>";
        $("#select_game .lista_partidas ul").append(li);
     }
     $("#select_game .lista_partidas ul li").click(function(){
         playSound("pop");
         $.game = new Game();
         $.game.loadSavedGame(datos[$(this).data("ref")]);
         initAlertLaunched = true;
         $("#main_wrapper").simpleHorizontalNavigator("gotoPage", "game", preenter_page_game, loaded_page_game);
     });
    $(".lista_partidas ul li i").click(function(event){
        playSound("pop");
        event.stopPropagation();
        var _id = $(this).parent().data("ref");
        creaAlerta("prompt", textos["a_deleteGame"][idioma], deleteGame, [_id, datos]);
    });
}
function deleteGame(params){
    var datos = params[1];
    var _id = params[0];
    datos.splice(_id, 1);
   localStorage.setItem("testearte_primaria", JSON.stringify(datos));
    $("#select_game .lista_partidas ul li[data-ref='"+_id+"']").remove();
}




/*
 * página del juego
 */
function init_page_game(){
    $("#game .b_new").click(function(){
        creaAlerta("prompt", textos["a_quitGame"][idioma], dejarPartida, null);
    });
    $("#game .b_saveGame").click(function(){
        $.game.saveJSON();
    });
}
function preenter_page_game(){
   console.log("Entrando en el juego");
   actualizaAvatares();
    
    
}
function loaded_page_game(){
    if(!initAlertLaunched){
        initAlertLaunched = true;
        creaAlertaInit(textos["a_initGame"][idioma], "images/initGameAlert.png");
    }
    
    startTurno();
    
    setTimeout(function(){
        var canvas = $("canvas");
        canvas.css({display:"inherit"});
    }, 2000)
    
    
    $("#flechaPpal").click(function(){
        var data = $.game.get("partida").get("data");
        var turno = data.turno;
        var user = $.game.get("users").at(turno);
        window.playAvatar(window.root[user.get("color")+"_"+user.get("status")]);
    });
}
function dejarPartida(){
    $.game = new Game();
    $.game.get("tarjetas").add(tarjetas);
    $.game.get("categorias").add(categorias);
    $.game.set("historialTarjetas", new TarjetasCollection());
    $("canvas").hide();
    $("#main_wrapper").simpleHorizontalNavigator("gotoPage", "home", null, null);
}







/*
 * página selección de idioma
 */
function init_page_ayuda(){
    $("#help .b_home").click(function(){
        $(".explicacionBlanco_ayuda").slideUp("fast");
        $("#main_wrapper").simpleHorizontalNavigator("gotoPage", "home", null, null);
    });
    $(".explicacionBlanco_ayuda").not(':first').slideUp();
    $(".contenedor_ayuda h4").click(function(){
        var _div = $(this).parent().find(".explicacionBlanco_ayuda");
        $(".explicacionBlanco_ayuda").slideUp("fast");
        _div.stop().slideToggle("fast");
    });
    
    
}
function pintaMediateca(){
    // cargo la mediateca 
    $(".mediateca").html("");
    for(var i=0; i<window.tarjetas.length; i++){
        var _url = 'http://contanimacion.com/testearte/web/imagenes/big/'+tarjetas[i].imagen;
        var _url2 = 'http://contanimacion.com/testearte/web/imagenes/thumb/'+tarjetas[i].imagen;
        if(local){
            _url = "images/imagenes_tarjetas/big/"+tarjetas[i].imagen;
            _url2 = "images/imagenes_tarjetas/thumb/"+tarjetas[i].imagen;
        }
        $(".mediateca").append("<li><span class='imagen'><a href='"+_url+"' target='_blank'><img src='"+_url2+"'></a></span><span class='info'>"+tarjetas[i].origen+"</span></li>")
    }
}
function pintaRecursos(){
    // cargo la mediateca 
    $(".recursos").html("");
    for(var i=0; i<window.tarjetas.length; i++){
        if(tarjetas[i].recursos){
            var _url = 'http://contanimacion.com/testearte/web/imagenes/big/'+tarjetas[i].imagen;
            var _url2 = 'http://contanimacion.com/testearte/web/imagenes/thumb/'+tarjetas[i].imagen;
            if(local){
                _url = "images/imagenes_tarjetas/big/"+tarjetas[i].imagen;
                _url2 = "images/imagenes_tarjetas/thumb/"+tarjetas[i].imagen;
            }
            $(".recursos").append("<li><span class='imagen'><a href='"+_url+"' target='_blank'><img src='"+_url2+"'></a></span><a href='"+tarjetas[i].recursos+"' target='_blank'><span class='info'>"+tarjetas[i].recursos+"</span></a></li>")
   
        }
    }
}






/*
 * funciones globales
 */

// sistema de alertas
//creaAlerta("alerta", "Debes escribir un nombre", null, null);
//creaAlerta("prompt", "¿Seguro que quieres borrar el usuario?", $.game.deletePlayer, $(this).data("id"));
function creaAlerta(tipo, texto, funcion, param){
    var _div = '<div class="fondo_alerta"><div class="alerta">';
    _div += '<p class="alerta_rotulo"></p>'
    _div += '<div class="bottom_buttonbar">';
    if(tipo == "prompt"){
        _div += '<a class="b_delete boton_normal boton_texto boton_dcha">'+textos["b_aceptar"][idioma]+'</a>';
        _div += '<a class="b_cancel boton_normal boton_texto boton_izda">'+textos["b_cancelar"][idioma]+'</a>';
    }else if(tipo == "alerta"){
        _div += '<a class="b_cancel boton_normal boton_texto boton_central">'+textos["b_aceptar"][idioma]+'</a>';
    }
    _div += '</div>';
    _div += '</div></div>';
    var div = $(_div);
    
    div.find(".alerta_rotulo").html(texto)
    div.find(".b_cancel").click(function(){
        playSound("pop");
            div.animate({opacity: 0}, {duration: 500, complete:function(){div.remove();}});
    })
    div.find(".b_delete").click(function(){
        playSound("pop");
            funcion(param);
            div.animate({opacity: 0}, {duration: 500, complete:function(){div.remove();}});
    });
    div.css("opacity", 0);
    $("body").append(div);
    div.animate({opacity: 1}, {duration: 500});
}


//alerta al comenzar el juego
function creaAlertaInit(texto, rutaImagen){
    var _div = '<div id="alertasIniciales" class="fondo_alerta"><div id="alertaInit" class="alerta">';
    _div += '<p class="alerta_rotulo">'+texto+'</p>';
    _div += '<img class="imagealert" src="'+rutaImagen+'">';
    _div += '<div class="bottom_buttonbar">';
    _div += '<a class="b_cancel boton_normal boton_texto boton_central">'+textos["b_aceptar"][idioma]+'</a>';
    _div += '</div>';
    _div += '</div></div>';
    var div = $(_div);
    div.find(".b_cancel").click(function(){
        playSound("pop");
        div.animate({opacity: 0}, {duration: 500, complete:function(){div.remove();}});
    })
    div.css("opacity", 0);
    $("body").append(div);
    div.animate({opacity: 1}, {duration: 500});
}




/*
 * carga de idiomas
 */
function cargaTextos(){
    for (ref in textos){
        var elemento = document.getElementById(ref);
        if(elemento){
            elemento.innerHTML = textos[ref][idioma];
        }
    }
}




/* 
 * parte de sonidos
 */
function playSound (audio_id) {
    createjs.Sound.play(audio_id);
}

function check_audio() {
  var elem = document.createElement('audio'), bool = false;
  try{
    if ( bool = !!elem.canPlayType ){
      bool = new Boolean(bool);
      bool.ogg = elem.canPlayType('audio/ogg; codecs="vorbis"').replace(/^no$/,'');
      bool.mp3 = elem.canPlayType('audio/mpeg;').replace(/^no$/,'');
      bool.wav = elem.canPlayType('audio/wav; codecs="1"').replace(/^no$/,'');
      bool.m4a = (elem.canPlayType('audio/x-m4a;') || elem.canPlayType('audio/aac;')).replace(/^no$/,'');
    }
  } catch(e) { 
  }
  return bool;
}
 

function loadAudios(){
    //alert($("html").attr('class'));
    if(!$("html").hasClass("ipad")){
        var _div = '<div class="fondo_alerta"><div class="alerta">';
        _div += '<p class="alerta_rotulo"><br><br>Cargando sonidos</p>'
        _div += '</div></div>';
        var div = $(_div);
        div.css("opacity", 0);
        $("body").append(div);
        div.animate({opacity: 1}, {duration: 500});
        
        var audioType = check_audio();
        var extension;
        console.debug(audioType);
        if(audioType.mp3 == "maybe" || audioType.mp3 == "probably"){
            extension = ".mp3";
        }else{
            extension = ".ogg";
        }
        var queue = new createjs.LoadQueue(false);
        createjs.Sound.registerPlugins([ createjs.HTMLAudioPlugin]);
        createjs.Sound.alternateExtensions = ["mp3"];
        queue.installPlugin(createjs.Sound);
        queue.addEventListener("complete", function(event){
            //alert("Queue cargados");
            div.remove();
        });
       /* queue.addEventListener("fileload", function(event){
            alert("Archivo cargado");
        });*/
        queue.loadManifest([
            {id:"pop", src:"sounds/pop"+extension},
            {id:"risa", src:"sounds/risa"+extension},
            {id:"ruletaSound", src:"sounds/ruleta"+extension},
            {id:"aplauso", src:"sounds/aplauso"+extension},

            {id:"sonido_9_es", src:"sounds/categorias/sonido_9_es"+extension},
            {id:"sonido_9_ga", src:"sounds/categorias/sonido_9_ga"+extension},
            {id:"sonido_9_en", src:"sounds/categorias/sonido_9_en"+extension},
            {id:"sonido_10_es", src:"sounds/categorias/sonido_10_es"+extension},
            {id:"sonido_10_ga", src:"sounds/categorias/sonido_10_ga"+extension},
            {id:"sonido_10_en", src:"sounds/categorias/sonido_10_en"+extension},
            {id:"sonido_11_es", src:"sounds/categorias/sonido_11_es"+extension},
            {id:"sonido_11_ga", src:"sounds/categorias/sonido_11_ga"+extension},
            {id:"sonido_11_en", src:"sounds/categorias/sonido_11_en"+extension},
            {id:"sonido_12_es", src:"sounds/categorias/sonido_12_es"+extension},
            {id:"sonido_12_ga", src:"sounds/categorias/sonido_12_ga"+extension},
            {id:"sonido_12_en", src:"sounds/categorias/sonido_12_en"+extension},
            {id:"sonido_13_es", src:"sounds/categorias/sonido_13_es"+extension},
            {id:"sonido_13_ga", src:"sounds/categorias/sonido_13_ga"+extension},
            {id:"sonido_13_en", src:"sounds/categorias/sonido_13_en"+extension},
            {id:"sonido_14_es", src:"sounds/categorias/sonido_14_es"+extension},
            {id:"sonido_14_ga", src:"sounds/categorias/sonido_14_ga"+extension},
            {id:"sonido_14_en", src:"sounds/categorias/sonido_14_en"+extension},
        ]);
    }else{
        createjs.Sound.alternateExtensions = ["mp3"];
    
   
        createjs.Sound.addEventListener("complete", function(event){
            console.log("Queue cargados");
            div.remove();
        });

        createjs.Sound.addEventListener("fileload", function(event){
            console.log("Archivo cargado:", event.id, event.src);
        });

        var sounds = [
            {id:"pop", src:"sounds/pop.ogg"},
            {id:"risa", src:"sounds/risa.ogg"},
            {id:"ruletaSound", src:"sounds/ruleta.ogg"},
            {id:"aplauso", src:"sounds/aplauso.ogg"},

            {id:"sonido_9_es", src:"sounds/categorias/sonido_9_es.ogg"},
            {id:"sonido_9_ga", src:"sounds/categorias/sonido_9_ga.ogg"},
            {id:"sonido_9_en", src:"sounds/categorias/sonido_9_en.ogg"},
            {id:"sonido_10_es", src:"sounds/categorias/sonido_10_es.ogg"},
            {id:"sonido_10_ga", src:"sounds/categorias/sonido_10_ga.ogg"},
            {id:"sonido_10_en", src:"sounds/categorias/sonido_10_en.ogg"},
            {id:"sonido_11_es", src:"sounds/categorias/sonido_11_es.ogg"},
            {id:"sonido_11_ga", src:"sounds/categorias/sonido_11_ga.ogg"},
            {id:"sonido_11_en", src:"sounds/categorias/sonido_11_en.ogg"},
            {id:"sonido_12_es", src:"sounds/categorias/sonido_12_es.ogg"},
            {id:"sonido_12_ga", src:"sounds/categorias/sonido_12_ga.ogg"},
            {id:"sonido_12_en", src:"sounds/categorias/sonido_12_en.ogg"},
            {id:"sonido_13_es", src:"sounds/categorias/sonido_13_es.ogg"},
            {id:"sonido_13_ga", src:"sounds/categorias/sonido_13_ga.ogg"},
            {id:"sonido_13_en", src:"sounds/categorias/sonido_13_en.ogg"},
            {id:"sonido_14_es", src:"sounds/categorias/sonido_14_es.ogg"},
            {id:"sonido_14_ga", src:"sounds/categorias/sonido_14_ga.ogg"},
            {id:"sonido_14_en", src:"sounds/categorias/sonido_14_en.ogg"},
        ];
        createjs.Sound.registerSounds(sounds);
    }
}
