/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;

class Parrilla {
    static final String LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    static final int MAX = 100;
    public int x = 0;
    public int y = 0;
    public int width;
    public int height;
    public boolean select;
    public int startX;
    public int startY;
    public int endX;
    public int endY;
    public int size;
    private int rows;
    private int cols;
    private Font font;
    private FontMetrics fm;
    private Color fgColor = Color.black;
    private Color bgColor = Color.white;
    private Color bdColor = Color.black;
    private Color fdColor = Color.black;
    private Color hiColor = Color.black;
    private char[][] grid;

    public Parrilla(int n, int n2, int n3, Font font) {
        this.rows = n;
        this.cols = n2;
        this.font = font;
        this.size = n3;
        this.select = false;
        this.width = n2 * this.size;
        this.height = n * this.size;
    }

    public void setColors(Color color, Color color2, Color color3, Color color4, Color color5) {
        this.fgColor = color;
        this.bgColor = color2;
        this.bdColor = color3;
        this.fdColor = color4;
        this.hiColor = color5;
    }

    public void clear() {
        this.grid = new char[this.rows][this.cols];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.grid[i][j] = 32;
            }
        }
    }

    public boolean inside(int n, int n2) {
        return n > this.x && n < this.x + this.width && n2 > this.y && n2 < this.y + this.height;
    }

    public void cubrir() {
        int n;
        int n2;
        this.clear();
        for (n2 = 0; n2 < ArdoraSopa.words.size(); ++n2) {
            Palabra palabra = (Palabra)ArdoraSopa.words.elementAt(n2);
            int n3 = (int)(Math.random() * (double)this.rows);
            int n4 = (int)(Math.random() * (double)this.cols);
            boolean bl = false;
            if (palabra.grid.length() <= Math.max(this.rows, this.cols)) {
                n = n3;
                int n5 = n4;
                do {
                    if ((bl = this.addWord(palabra, n, n5)) || ++n5 <= this.cols - 1) continue;
                    n5 = 0;
                    if (++n <= this.rows - 1) continue;
                    n = 0;
                } while (!bl && (n != n3 || n5 != n4));
            }
            if (bl) continue;
            ArdoraSopa.words.removeElementAt(n2);
            ArdoraSopa.definicions[n2] = "";
            --n2;
        }
        for (n2 = 0; n2 < this.rows; ++n2) {
            for (int i = 0; i < this.cols; ++i) {
                if (this.grid[n2][i] != ' ') continue;
                n = (int)(Math.random() * (double)LETTERS.length());
                this.grid[n2][i] = LETTERS.charAt(n);
            }
        }
    }

    private boolean addWord(Palabra palabra, int n, int n2) {
        int n3;
        int n4;
        int n5;
        boolean bl;
        int n6 = (int)(Math.random() * 1.0);
        int n7 = (int)(Math.random() * 1.0);
        if (n7 == 1 & n6 == 0) {
            n7 = 1;
            n6 = 1;
        }
        int n8 = 0;
        do {
            bl = true;
            n5 = n + (palabra.grid.length() - 1) * n6;
            n4 = n2 + (palabra.grid.length() - 1) * n7;
            if ((n7 != 0 || n6 != 0) && n5 >= 0 && n5 < this.rows && n4 >= 0 && n4 < this.cols) {
                for (n3 = 0; n3 < palabra.grid.length(); ++n3) {
                    char c = this.grid[n + n3 * n6][n2 + n3 * n7];
                    if (c == ' ' || c == palabra.grid.charAt(n3)) continue;
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (bl || ++n7 <= 1) continue;
            n7 = 0;
            if (++n6 <= 1) continue;
            n6 = 0;
        } while (!bl && ++n8 <= 8);
        if (bl) {
            for (n3 = 0; n3 < palabra.grid.length(); ++n3) {
                this.grid[n + n3 * n6][n2 + n3 * n7] = palabra.grid.charAt(n3);
            }
            palabra.endpt1 = new Point(n2, n);
            palabra.endpt2 = new Point(n4, n5);
        }
        return bl;
    }

    public boolean checkSelection() {
        int n = Math.min(Math.max(this.startX / this.size, 0), this.cols - 1);
        int n2 = Math.min(Math.max(this.startY / this.size, 0), this.rows - 1);
        int n3 = Math.min(Math.max(this.endX / this.size, 0), this.cols - 1);
        int n4 = Math.min(Math.max(this.endY / this.size, 0), this.rows - 1);
        Point point = new Point(n, n2);
        Point point2 = new Point(n3, n4);
        for (int i = 0; i < ArdoraSopa.words.size(); ++i) {
            Palabra palabra = (Palabra)ArdoraSopa.words.elementAt(i);
            if ((!palabra.endpt1.equals(point) || !palabra.endpt2.equals(point2)) && (!palabra.endpt1.equals(point2) || !palabra.endpt2.equals(point))) continue;
            palabra.found = true;
            return true;
        }
        return false;
    }

    public void draw(Graphics graphics) {
        int n;
        Polygon polygon;
        int n2;
        int n3;
        int n4;
        int n5;
        Palabra palabra;
        int n6;
        graphics.setColor(this.bgColor);
        graphics.fillRect(this.x, this.y, this.width, this.height);
        graphics.setColor(this.bdColor);
        graphics.drawRect(this.x, this.y, this.width - 1, this.height - 1);
        graphics.setColor(this.fdColor);
        for (n6 = 0; n6 < ArdoraSopa.words.size(); ++n6) {
            palabra = (Palabra)ArdoraSopa.words.elementAt(n6);
            if (!palabra.found) continue;
            n5 = this.x + this.size * palabra.endpt1.x + this.size / 2;
            n4 = this.y + this.size * palabra.endpt1.y + this.size / 2;
            n3 = this.x + this.size * palabra.endpt2.x + this.size / 2;
            n2 = this.y + this.size * palabra.endpt2.y + this.size / 2;
            polygon = this.getPolygon(n5, n4, n3, n2);
            graphics.fillPolygon(polygon);
        }
        if (ArdoraSopa.words.size() > 0 && this.select) {
            n6 = Math.min(Math.max(this.startY / this.size, 0), this.rows - 1);
            n = Math.min(Math.max(this.startX / this.size, 0), this.cols - 1);
            int n7 = Math.min(Math.max(this.endY / this.size, 0), this.rows - 1);
            int n8 = Math.min(Math.max(this.endX / this.size, 0), this.cols - 1);
            n5 = this.size * n + this.size / 2;
            n4 = this.size * n6 + this.size / 2;
            n3 = this.size * n8 + this.size / 2;
            n2 = this.size * n7 + this.size / 2;
            polygon = this.getPolygon(n5, n4, n3, n2);
            graphics.setColor(this.hiColor);
            graphics.fillPolygon(polygon);
            graphics.setColor(this.fgColor);
            graphics.drawPolygon(polygon);
            graphics.drawLine(polygon.xpoints[polygon.npoints - 1], polygon.ypoints[polygon.npoints - 1], polygon.xpoints[0], polygon.ypoints[0]);
        }
        graphics.setFont(this.font);
        graphics.setColor(this.fgColor);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        for (n6 = 0; n6 < this.rows; ++n6) {
            for (n = 0; n < this.cols; ++n) {
                Character c = new Character(this.grid[n6][n]);
                int n9 = this.x + n * this.size + (this.size - fontMetrics.stringWidth(c.toString())) / 2;
                int n10 = this.y + n6 * this.size + (this.size - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
                graphics.drawString(c.toString(), n9, n10);
            }
        }
        graphics.setColor(this.fgColor);
        for (n6 = 0; n6 < ArdoraSopa.words.size(); ++n6) {
            palabra = (Palabra)ArdoraSopa.words.elementAt(n6);
            if (!palabra.found) continue;
            n5 = this.x + this.size * palabra.endpt1.x + this.size / 2;
            n4 = this.y + this.size * palabra.endpt1.y + this.size / 2;
            n3 = this.x + this.size * palabra.endpt2.x + this.size / 2;
            n2 = this.y + this.size * palabra.endpt2.y + this.size / 2;
            polygon = this.getPolygon(n5, n4, n3, n2);
            graphics.drawPolygon(polygon);
            graphics.drawLine(polygon.xpoints[polygon.npoints - 1], polygon.ypoints[polygon.npoints - 1], polygon.xpoints[0], polygon.ypoints[0]);
        }
    }

    private Polygon getPolygon(int n, int n2, int n3, int n4) {
        double d;
        double d2 = n3 - n;
        double d3 = n4 - n2;
        double d4 = 0.0;
        if (d2 == 0.0) {
            if (d3 < 0.0) {
                d4 = 1.5707963267948966;
            } else if (d3 > 0.0) {
                d4 = 4.71238898038469;
            }
        } else if (d3 == 0.0) {
            d4 = d2 > 0.0 ? 0.0 : Math.PI;
        } else {
            d4 = Math.atan(Math.abs(d3 / d2));
            if (d2 < 0.0 && d3 < 0.0) {
                d4 = Math.PI - d4;
            }
            if (d2 < 0.0 && d3 > 0.0) {
                d4 += Math.PI;
            }
            if (d2 > 0.0 && d3 > 0.0) {
                d4 = Math.PI * 2 - d4;
            }
        }
        double d5 = (d4 += 1.5707963267948966) + Math.PI;
        Polygon polygon = new Polygon();
        int n5 = (int)Math.round((double)this.size * Math.sin(0.7853981633974483) / 2.0);
        for (d = d4; d < d4 + Math.PI; d += 0.10471975511965977) {
            polygon.addPoint((int)Math.round((double)n + (double)n5 * Math.cos(d)), (int)Math.round((double)n2 - (double)n5 * Math.sin(d)));
        }
        polygon.addPoint((int)Math.round((double)n + (double)n5 * Math.cos(d5)), (int)Math.round((double)n2 - (double)n5 * Math.sin(d5)));
        for (d = d5; d < d5 + Math.PI; d += 0.10471975511965977) {
            polygon.addPoint((int)Math.round((double)n3 + (double)n5 * Math.cos(d)), (int)Math.round((double)n4 - (double)n5 * Math.sin(d)));
        }
        polygon.addPoint((int)Math.round((double)n3 + (double)n5 * Math.cos(d4)), (int)Math.round((double)n4 - (double)n5 * Math.sin(d4)));
        return polygon;
    }
}

