/*
 * Decompiled with CFR 0.152.
 */
import java.util.Iterator;
import java.util.Vector;

class SoundPlayer
implements Runnable {
    static Vector activeSounds = new Vector();
    static Thread sndThread;

    SoundPlayer() {
    }

    static synchronized Object startSound(Object object, Sprite sprite, LContext lContext) {
        if (!(object instanceof ScratchSound)) {
            Logo.error("argument of startSound must be a ScratchSound", lContext);
            return new Object[0];
        }
        Object[] objectArray = activeSounds.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            PlayingSound playingSound = (PlayingSound)objectArray[i];
            if (playingSound.snd != (ScratchSound)object || playingSound.sprite != sprite) continue;
            playingSound.closeLine();
            activeSounds.remove(playingSound);
        }
        PlayingSound playingSound = new PlayingSound((ScratchSound)object, sprite);
        playingSound.startPlaying(lContext);
        activeSounds.add(playingSound);
        return playingSound;
    }

    static synchronized boolean isSoundPlaying(Object object) {
        if (!(object instanceof PlayingSound)) {
            return false;
        }
        return ((PlayingSound)object).isPlaying();
    }

    static synchronized void stopSound(Object object) {
        if (!(object instanceof PlayingSound)) {
            return;
        }
        ((PlayingSound)object).closeLine();
        activeSounds.remove(object);
    }

    static synchronized void stopSoundsForApplet(LContext lContext) {
        PlayerPrims.stopMIDINotes();
        Vector<PlayingSound> vector = new Vector<PlayingSound>();
        Iterator iterator = activeSounds.iterator();
        while (iterator.hasNext()) {
            PlayingSound playingSound = (PlayingSound)iterator.next();
            if (playingSound.owner == lContext) {
                playingSound.closeLine();
                continue;
            }
            vector.addElement(playingSound);
        }
        activeSounds = vector;
    }

    static synchronized void updateActiveSounds() {
        Vector<PlayingSound> vector = new Vector<PlayingSound>();
        Iterator iterator = activeSounds.iterator();
        while (iterator.hasNext()) {
            PlayingSound playingSound = (PlayingSound)iterator.next();
            if (playingSound.isPlaying()) {
                playingSound.writeSomeSamples();
                vector.addElement(playingSound);
                continue;
            }
            playingSound.closeLine();
        }
        activeSounds = vector;
    }

    static synchronized void startPlayer() {
        sndThread = new Thread((Runnable)new SoundPlayer(), "SoundPlayer");
        sndThread.setPriority(10);
        sndThread.start();
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (sndThread == thread) {
            SoundPlayer.updateActiveSounds();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

