/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import javax.swing.JPanel;

class PlayerCanvas
extends JPanel
implements KeyListener,
MouseListener,
MouseMotionListener {
    static final String versionString = "v38";
    static final int width = 482;
    static final int height = 387;
    static final int topBarHeight = 26;
    static final int goButtonX = 418;
    static final int stopButtonX = 451;
    static final int buttonY = 4;
    static final Color BLACK = new Color(0, 0, 0);
    static final Color WHITE = new Color(255, 255, 255);
    static final int soundInputBufSize = 50000;
    static TargetDataLine soundInputLine;
    byte[] soundInputBuf = new byte[50000];
    int soundLevel = 0;
    boolean overGoButton = false;
    boolean overStopButton = false;
    String message = "";
    boolean isLoading = true;
    double loadingFraction = 0.2;
    LContext lc;
    Sprite stage;
    Object[] sprites = new Object[0];
    BufferedImage offscreen;
    BufferedImage penTrails;
    Rectangle invalrect = new Rectangle();
    int mouseX;
    int mouseY;
    boolean mouseIsDown = false;
    int mouseDownX;
    int mouseDownY;
    Drawable mouseDragTarget;
    int mouseDragXOffset;
    int mouseDragYOffset;
    boolean reportClickOnMouseUp;
    Vector mouseclicks = new Vector();
    boolean[] keydown = new boolean[256];
    Vector keystrokes = new Vector();
    AskPrompter askPrompt = null;
    String lastAnswer = "";
    static /* synthetic */ Class class$javax$sound$sampled$TargetDataLine;

    PlayerCanvas() {
        this.setLayout(null);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void addNotify() {
        super.addNotify();
        this.offscreen = (BufferedImage)this.createImage(482, 387);
        this.offscreen.getRaster();
        Graphics graphics = this.offscreen.getGraphics();
        graphics.setColor(WHITE);
        graphics.fillRect(0, 0, 482, 387);
        graphics.dispose();
        this.repaint();
    }

    public Dimension getMinimumSize() {
        return new Dimension(482, 387);
    }

    public Dimension getPreferredSize() {
        return new Dimension(482, 387);
    }

    public synchronized void paintComponent(Graphics graphics) {
        graphics.drawImage(this.offscreen, 0, 0, 482, 387, this);
    }

    void clearall(LContext lContext) {
        this.stage = null;
        this.sprites = new Object[0];
        this.askPrompt = null;
        this.lastAnswer = "";
        this.penTrails = null;
        SoundPlayer.stopSoundsForApplet(lContext);
        this.soundLevel = 0;
        lContext.props = new Hashtable();
        Runtime.getRuntime().gc();
        this.clearkeys();
        this.mouseclicks = new Vector();
        this.mouseIsDown = false;
        this.mouseDragTarget = null;
    }

    void setMessage(String string) {
        this.message = string;
        this.redraw_all();
    }

    synchronized void inval(Rectangle rectangle) {
        this.invalrect = this.invalrect.isEmpty() ? new Rectangle(rectangle) : this.invalrect.union(rectangle);
    }

    void invalAll() {
        this.inval(new Rectangle(0, 0, 482, 387));
    }

    void redraw_all() {
        this.redraw(new Rectangle(0, 0, 482, 387), false);
    }

    void redraw_invalid() {
        this.redraw(this.invalrect, false);
    }

    synchronized void redraw(Rectangle rectangle, boolean bl) {
        Graphics graphics = this.offscreen.getGraphics();
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(WHITE);
        graphics.fillRect(0, 0, 482, 387);
        if (this.isLoading) {
            this.drawProgressBar(graphics);
        } else {
            Drawable drawable;
            int n;
            if (this.stage != null) {
                this.stage.setStageOffset();
                this.stage.paint(graphics);
            }
            if (this.penTrails != null) {
                graphics.drawImage(this.penTrails, 0, 0, 482, 387, null);
            }
            for (n = this.sprites.length - 1; n >= 0; --n) {
                drawable = (Drawable)this.sprites[n];
                if (!drawable.isShowing() || !rectangle.intersects(drawable.fullRect())) continue;
                drawable.paint(graphics);
            }
            for (n = this.sprites.length - 1; n >= 0; --n) {
                drawable = (Drawable)this.sprites[n];
                if (!drawable.isShowing() || !rectangle.intersects(drawable.fullRect())) continue;
                drawable.paintBubble(graphics);
            }
            if (this.askPrompt != null) {
                this.askPrompt.paint(graphics);
            }
        }
        this.drawBorder(graphics);
        if (bl) {
            graphics.setColor(new Color(200, 0, 0));
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics.dispose();
        this.repaint(rectangle);
        this.invalrect = new Rectangle();
    }

    void drawBorder(Graphics graphics) {
        graphics.setColor(new Color(130, 130, 130));
        graphics.fillRect(0, 0, 482, 25);
        graphics.setColor(BLACK);
        graphics.fillRect(0, 0, 482, 1);
        graphics.fillRect(0, 0, 1, 387);
        graphics.fillRect(0, 386, 482, 1);
        graphics.fillRect(481, 0, 1, 387);
        graphics.fillRect(0, 25, 482, 1);
        graphics.drawImage(this.overGoButton ? Skin.goButtonOver : Skin.goButton, 418, 4, null);
        graphics.drawImage(this.overStopButton ? Skin.stopButtonOver : Skin.stopButton, 451, 4, null);
        graphics.setColor(WHITE);
        graphics.setFont(new Font("SansSerif", 0, 8));
        graphics.drawString(versionString, 5, 11);
        if (this.message.length() > 0) {
            graphics.setFont(new Font("SansSerif", 1, 13));
            graphics.setColor(new Color(250, 250, 0));
            graphics.drawString(this.message, 70, 17);
        }
    }

    void drawProgressBar(Graphics graphics) {
        graphics.setColor(BLACK);
        graphics.setFont(new Font("SansSerif", 1, 24));
        graphics.drawString("Loading...", 188, 173);
        int n = 91;
        int n2 = 193;
        graphics.fillRect(n, n2, 300, 1);
        graphics.fillRect(n, n2, 1, 29);
        graphics.fillRect(n, n2 + 28, 300, 1);
        graphics.fillRect(n + 299, n2, 1, 29);
        graphics.setColor(new Color(10, 10, 200));
        graphics.fillRect(n + 2, n2 + 2, (int)(296.0 * Math.min(this.loadingFraction, 1.0)), 25);
        this.drawBorder(graphics);
    }

    BufferedImage drawAreaWithoutSprite(Rectangle rectangle, Sprite sprite) {
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(WHITE);
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics = graphics.create(-rectangle.x, -rectangle.y, rectangle.width, rectangle.height);
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.stage != null) {
            this.stage.setStageOffset();
            this.stage.paint(graphics);
        }
        if (this.penTrails != null) {
            graphics.drawImage(this.penTrails, 0, 0, 482, 387, null);
        }
        for (int i = this.sprites.length - 1; i >= 0; --i) {
            Drawable drawable = (Drawable)this.sprites[i];
            if (drawable == sprite || !drawable.isShowing() || !rectangle.intersects(drawable.rect())) continue;
            drawable.paint(graphics);
        }
        graphics.dispose();
        return bufferedImage;
    }

    void drawRect(int n, int n2, int n3, int n4) {
        Graphics graphics = this.offscreen.getGraphics();
        graphics.setColor(BLACK);
        graphics.fillRect(n, n2, n3, n4);
        graphics.dispose();
        this.repaint();
    }

    void startLoading() {
        this.isLoading = true;
        this.loadingFraction = 0.0;
        this.redraw_all();
    }

    void stopLoading() {
        this.loadingFraction = 1.0;
        this.redraw_all();
        this.loadingFraction = 0.0;
        this.isLoading = false;
    }

    void loadingProgress(double d) {
        this.loadingFraction = d;
        this.redraw_all();
    }

    boolean logoIsRunning() {
        return this.lc.logoThread != null;
    }

    void updatePenTrails() {
        for (int i = this.sprites.length - 1; i >= 0; --i) {
            if (!(this.sprites[i] instanceof Sprite)) continue;
            Sprite sprite = (Sprite)this.sprites[i];
            if (!sprite.penDown) continue;
            this.updatePenTrailForSprite(sprite);
        }
    }

    void updatePenTrailForSprite(Sprite sprite) {
        if (this.penTrails == null) {
            this.createPenTrails();
        }
        int n = 241 + (int)sprite.x;
        int n2 = 206 - (int)sprite.y;
        if ((double)sprite.lastPenX == -1000000.0) {
            sprite.lastPenX = n;
            sprite.lastPenY = n2;
        } else if (sprite.lastPenX == n && sprite.lastPenY == n2) {
            return;
        }
        Graphics2D graphics2D = this.penTrails.createGraphics();
        graphics2D.setColor(sprite.penColor);
        graphics2D.setStroke(new BasicStroke(sprite.penSize, 1, 1));
        graphics2D.drawLine(sprite.lastPenX, sprite.lastPenY, n, n2);
        graphics2D.dispose();
        Rectangle rectangle = new Rectangle(sprite.lastPenX, sprite.lastPenY, 0, 0);
        rectangle.add(n, n2);
        rectangle.grow(sprite.penSize, sprite.penSize);
        this.inval(rectangle);
        sprite.lastPenX = n;
        sprite.lastPenY = n2;
    }

    void stampCostume(Sprite sprite) {
        if (this.penTrails == null) {
            this.createPenTrails();
        }
        Graphics2D graphics2D = this.penTrails.createGraphics();
        if (sprite.filterChanged) {
            sprite.applyFilters();
        }
        graphics2D.drawImage((Image)sprite.outImage(), sprite.screenX(), sprite.screenY(), null);
        graphics2D.dispose();
        sprite.inval();
    }

    void createPenTrails() {
        this.penTrails = new BufferedImage(482, 387, 2);
        this.penTrails.getRaster();
    }

    void clearPenTrails() {
        if (this.penTrails != null) {
            this.penTrails.flush();
        }
        this.penTrails = null;
        this.inval(new Rectangle(0, 0, 482, 387));
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.requestFocus();
        this.mouseDragOrMove(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.updateMouseXY(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseDown(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseUp(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.updateMouseXY(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseDragOrMove(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseDragOrMove(mouseEvent);
    }

    void mouseDown(MouseEvent mouseEvent) {
        boolean bl;
        Drawable drawable;
        this.updateMouseXY(mouseEvent);
        this.requestFocus();
        if (this.inGoButton(mouseEvent)) {
            this.doStopButton();
            LogoCommandRunner.startLogoThread("greenflag", this.lc);
            return;
        }
        if (this.inStopButton(mouseEvent)) {
            this.doStopButton();
            LogoCommandRunner.startLogoThread("interact", this.lc);
            return;
        }
        this.mouseIsDown = true;
        this.mouseDownX = mouseEvent.getX();
        this.mouseDownY = mouseEvent.getY();
        this.mouseDragTarget = this.findDragTarget(mouseEvent.getX(), mouseEvent.getY());
        this.mouseDragYOffset = 0;
        this.mouseDragXOffset = 0;
        this.reportClickOnMouseUp = true;
        if (this.mouseDragTarget instanceof Sprite) {
            drawable = (Sprite)this.mouseDragTarget;
            if (((Sprite)drawable).isDraggable) {
                this.mouseDragXOffset = ((Sprite)drawable).screenX() - mouseEvent.getX();
                this.mouseDragYOffset = ((Sprite)drawable).screenY() - mouseEvent.getY();
                this.moveSpriteToFront((Sprite)drawable);
            } else {
                this.mouseDragTarget = null;
            }
        }
        if (this.mouseDragTarget instanceof ListWatcher) {
            drawable = (ListWatcher)this.mouseDragTarget;
            ((ListWatcher)drawable).mouseDown(mouseEvent.getX(), mouseEvent.getY());
        }
        if (this.askPrompt != null && (bl = this.askPrompt.mouseDown(mouseEvent.getX(), mouseEvent.getY(), this))) {
            return;
        }
        if (this.mouseDragTarget == null) {
            this.reportClick();
        }
    }

    void mouseDragOrMove(MouseEvent mouseEvent) {
        this.updateMouseXY(mouseEvent);
        if (mouseEvent.getX() != this.mouseDownX || mouseEvent.getY() != this.mouseDownY) {
            this.reportClickOnMouseUp = false;
        }
        if (this.mouseDragTarget != null) {
            this.mouseDragTarget.dragTo(mouseEvent.getX() + this.mouseDragXOffset, mouseEvent.getY() + this.mouseDragYOffset);
        } else {
            boolean bl = this.overGoButton;
            boolean bl2 = this.overStopButton;
            this.overGoButton = this.inGoButton(mouseEvent);
            this.overStopButton = this.inStopButton(mouseEvent);
            if (bl != this.overGoButton || bl2 != this.overStopButton) {
                this.inval(new Rectangle(0, 0, 482, 26));
                this.redraw_invalid();
            }
        }
    }

    void mouseUp(MouseEvent mouseEvent) {
        this.updateMouseXY(mouseEvent);
        if (this.reportClickOnMouseUp) {
            if (this.mouseDragTarget instanceof Watcher) {
                ((Watcher)this.mouseDragTarget).click(mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.reportClick();
            }
        }
        this.mouseDragTarget = null;
        this.mouseIsDown = false;
    }

    void reportClick() {
        Object[] objectArray = new Object[]{new Double(this.mouseDownX - 241), new Double(206 - this.mouseDownY)};
        this.mouseclicks.addElement(objectArray);
        this.reportClickOnMouseUp = false;
    }

    void updateMouseXY(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX() - 241;
        this.mouseY = 206 - mouseEvent.getY();
    }

    boolean inGoButton(MouseEvent mouseEvent) {
        if (mouseEvent.getY() >= 26) {
            return false;
        }
        int n = mouseEvent.getX();
        return n >= 418 && n <= 418 + Skin.goButton.getWidth(null);
    }

    boolean inStopButton(MouseEvent mouseEvent) {
        if (mouseEvent.getY() >= 26) {
            return false;
        }
        int n = mouseEvent.getX();
        return n >= 451 && n <= 451 + Skin.stopButton.getWidth(null);
    }

    void doStopButton() {
        SoundPlayer.stopSoundsForApplet(this.lc);
        LogoCommandRunner.stopLogoThread(this.lc);
        new LogoCommandRunner("stopAll", this.lc, true).run();
        this.clearkeys();
        this.mouseclicks = new Vector();
        this.mouseIsDown = false;
        this.mouseDragTarget = null;
        this.redraw_all();
    }

    Drawable findDragTarget(int n, int n2) {
        for (int i = 0; i < this.sprites.length; ++i) {
            Drawable drawable;
            if (this.sprites[i] instanceof Watcher && ((Watcher)(drawable = (Watcher)this.sprites[i])).inSlider(n, n2)) {
                return drawable;
            }
            if (this.sprites[i] instanceof ListWatcher && ((ListWatcher)(drawable = (ListWatcher)this.sprites[i])).inScrollbar(n, n2)) {
                return drawable;
            }
            if (!(this.sprites[i] instanceof Sprite) || !((Sprite)(drawable = (Sprite)this.sprites[i])).isShowing() || !((Sprite)drawable).containsPoint(n, n2)) continue;
            return drawable;
        }
        return null;
    }

    void moveSpriteToFront(Sprite sprite) {
        int n = -1;
        for (int i = 0; i < this.sprites.length; ++i) {
            if (this.sprites[i] != sprite) continue;
            n = i;
        }
        if (n < 0) {
            return;
        }
        Object object = this.sprites[n];
        for (int i = n; i > 0; --i) {
            this.sprites[i] = this.sprites[i - 1];
        }
        this.sprites[0] = object;
        sprite.inval();
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = this.keyCodeFor(keyEvent);
        this.keydown[n] = true;
        if (n == 10 || n >= 28 && n <= 31) {
            this.keystrokes.addElement(new Double(n));
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = this.keyCodeFor(keyEvent);
        this.keydown[n] = false;
    }

    public void keyTyped(KeyEvent keyEvent) {
        int n = keyEvent.getKeyChar();
        if (this.askPrompt != null) {
            this.askPrompt.handleKeystroke(n, this);
            return;
        }
        if (n >= 65 && n <= 90) {
            n += 32;
        }
        this.keystrokes.addElement(new Double(n));
    }

    int keyCodeFor(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 10) {
            return 10;
        }
        if (n == 37) {
            return 28;
        }
        if (n == 38) {
            return 30;
        }
        if (n == 39) {
            return 29;
        }
        if (n == 40) {
            return 31;
        }
        if (n >= 65 && n <= 90) {
            return n + 32;
        }
        return Math.min(n, 255);
    }

    void clearkeys() {
        for (int i = 0; i < this.keydown.length; ++i) {
            this.keydown[i] = false;
        }
        this.keystrokes = new Vector();
    }

    int soundLevel() {
        if (soundInputLine == null) {
            return 0;
        }
        int n = soundInputLine.available();
        if (n == 0) {
            return this.soundLevel;
        }
        n = soundInputLine.read(this.soundInputBuf, 0, n);
        int n2 = 0;
        for (int i = 0; i < n / 2; ++i) {
            int n3 = (this.soundInputBuf[2 * i] << 8) + this.soundInputBuf[2 * i + 1];
            if (n3 >= 32768) {
                n3 = 65536 - n3;
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        this.soundLevel = n2 / 327;
        return this.soundLevel;
    }

    void openSoundInput() {
        if (soundInputLine != null) {
            soundInputLine.close();
        }
        AudioFormat audioFormat = new AudioFormat(44100.0f, 16, 1, true, true);
        DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$TargetDataLine == null ? (class$javax$sound$sampled$TargetDataLine = PlayerCanvas.class$("javax.sound.sampled.TargetDataLine")) : class$javax$sound$sampled$TargetDataLine, audioFormat);
        try {
            soundInputLine = (TargetDataLine)AudioSystem.getLine(info);
            soundInputLine.open(audioFormat, 50000);
            soundInputLine.start();
        }
        catch (LineUnavailableException lineUnavailableException) {
            soundInputLine = null;
        }
    }

    void showAskPrompt(String string) {
        this.askPrompt = new AskPrompter(string);
        this.invalAll();
    }

    void hideAskPrompt() {
        if (this.askPrompt != null) {
            this.lastAnswer = this.askPrompt.answerString;
        }
        this.askPrompt = null;
        this.invalAll();
    }

    boolean askPromptShowing() {
        return this.askPrompt != null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

