/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.mixer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import org.tritonus.share.TDebug;
import org.tritonus.share.TNotifier;
import org.tritonus.share.sampled.mixer.TMixer;

public abstract class TLine
implements Line {
    private static final Control[] EMPTY_CONTROL_ARRAY = new Control[0];
    private Line.Info m_info;
    private boolean m_bOpen;
    private List m_controls;
    private Set m_lineListeners;
    private TMixer m_mixer;

    protected TLine(TMixer tMixer, Line.Info info) {
        this.setLineInfo(info);
        this.setOpen(false);
        this.m_controls = new ArrayList();
        this.m_lineListeners = new HashSet();
        this.m_mixer = tMixer;
    }

    protected TLine(TMixer tMixer, Line.Info info, Collection collection) {
        this(tMixer, info);
        this.m_controls.addAll(collection);
    }

    protected TMixer getMixer() {
        return this.m_mixer;
    }

    public Line.Info getLineInfo() {
        return this.m_info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLineInfo(Line.Info info) {
        if (TDebug.TraceLine) {
            TDebug.out("TLine.setLineInfo(): setting: " + info);
        }
        TLine tLine = this;
        synchronized (tLine) {
            this.m_info = info;
        }
    }

    public void open() throws LineUnavailableException {
        if (TDebug.TraceLine) {
            TDebug.out("TLine.open(): called");
        }
        if (!this.isOpen()) {
            if (TDebug.TraceLine) {
                TDebug.out("TLine.open(): opening");
            }
            this.openImpl();
            if (this.getMixer() != null) {
                this.getMixer().registerOpenLine(this);
            }
            this.setOpen(true);
        } else if (TDebug.TraceLine) {
            TDebug.out("TLine.open(): already open");
        }
    }

    protected void openImpl() throws LineUnavailableException {
        if (TDebug.TraceLine) {
            TDebug.out("TLine.openImpl(): called");
        }
    }

    public void close() {
        if (TDebug.TraceLine) {
            TDebug.out("TLine.close(): called");
        }
        if (this.isOpen()) {
            if (TDebug.TraceLine) {
                TDebug.out("TLine.close(): closing");
            }
            if (this.getMixer() != null) {
                this.getMixer().unregisterOpenLine(this);
            }
            this.closeImpl();
            this.setOpen(false);
        } else if (TDebug.TraceLine) {
            TDebug.out("TLine.close(): not open");
        }
    }

    protected void closeImpl() {
        if (TDebug.TraceLine) {
            TDebug.out("TLine.closeImpl(): called");
        }
    }

    public boolean isOpen() {
        return this.m_bOpen;
    }

    protected void setOpen(boolean bl) {
        if (TDebug.TraceLine) {
            TDebug.out("TLine.setOpen(): called, value: " + bl);
        }
        boolean bl2 = this.isOpen();
        this.m_bOpen = bl;
        if (bl2 != this.isOpen()) {
            if (this.isOpen()) {
                if (TDebug.TraceLine) {
                    TDebug.out("TLine.setOpen(): opened");
                }
                this.notifyLineEvent(LineEvent.Type.OPEN);
            } else {
                if (TDebug.TraceLine) {
                    TDebug.out("TLine.setOpen(): closed");
                }
                this.notifyLineEvent(LineEvent.Type.CLOSE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addControl(Control control) {
        List list = this.m_controls;
        synchronized (list) {
            this.m_controls.add(control);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeControl(Control control) {
        List list = this.m_controls;
        synchronized (list) {
            this.m_controls.remove(control);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Control[] getControls() {
        List list = this.m_controls;
        synchronized (list) {
            return this.m_controls.toArray(EMPTY_CONTROL_ARRAY);
        }
    }

    public Control getControl(Control.Type type) {
        List list = this.m_controls;
        synchronized (list) {
            Iterator iterator = this.m_controls.iterator();
            while (iterator.hasNext()) {
                Control control = (Control)iterator.next();
                if (!control.getType().equals(type)) continue;
                return control;
            }
            throw new IllegalArgumentException("no control of type " + type);
        }
    }

    public boolean isControlSupported(Control.Type type) {
        try {
            return this.getControl(type) != null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (TDebug.TraceAllExceptions) {
                TDebug.out(illegalArgumentException);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLineListener(LineListener lineListener) {
        Set set = this.m_lineListeners;
        synchronized (set) {
            this.m_lineListeners.add(lineListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLineListener(LineListener lineListener) {
        Set set = this.m_lineListeners;
        synchronized (set) {
            this.m_lineListeners.remove(lineListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getLineListeners() {
        Set set = this.m_lineListeners;
        synchronized (set) {
            return new HashSet(this.m_lineListeners);
        }
    }

    protected void notifyLineEvent(LineEvent.Type type) {
        this.notifyLineEvent(new LineEvent(this, type, -1L));
    }

    protected void notifyLineEvent(LineEvent lineEvent) {
        TNotifier.notifier.addEntry(lineEvent, this.getLineListeners());
    }
}

