/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.applet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.spi.mpeg.sampled.convert.MpegFormatConversionProvider;
import javazoom.spi.mpeg.sampled.file.MpegAudioFileReader;
import org.tritonus.applet.MpegAudioFileReaderWorkaround;

public class AppletMpegSPIWorkaround {
    public static boolean DEBUG = false;
    public static String useragent = null;

    public static AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        try {
            return AudioSystem.getAudioInputStream(audioFormat, audioInputStream);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (DEBUG) {
                System.err.println("Using AppletMpegSPIWorkaround to get codec");
            }
            try {
                Class.forName("javazoom.spi.mpeg.sampled.convert.MpegFormatConversionProvider");
                return new MpegFormatConversionProvider().getAudioInputStream(audioFormat, audioInputStream);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("Mpeg codec not properly installed");
            }
        }
    }

    public static AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            if (DEBUG) {
                System.err.println("Using AppletMpegSPIWorkaround to get codec (AudioInputStream:file)");
            }
            return AppletMpegSPIWorkaround.getAudioInputStream(bufferedInputStream);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            ((InputStream)bufferedInputStream).close();
            throw unsupportedAudioFileException;
        }
        catch (IOException iOException) {
            ((InputStream)bufferedInputStream).close();
            throw iOException;
        }
    }

    public static AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        try {
            Class.forName("javazoom.spi.mpeg.sampled.file.MpegAudioFileReader");
            return new MpegAudioFileReaderWorkaround().getAudioInputStream(uRL, useragent);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Mpeg codec not properly installed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            if (DEBUG) {
                System.err.println("Using AppletMpegSPIWorkaround to get codec (AudioFileFormat:file)");
            }
            AudioFileFormat audioFileFormat = AppletMpegSPIWorkaround.getAudioFileFormat(bufferedInputStream);
            return audioFileFormat;
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        Object object;
        BufferedInputStream bufferedInputStream = null;
        if (useragent != null) {
            object = uRL.openConnection();
            ((URLConnection)object).setUseCaches(false);
            ((URLConnection)object).setDoInput(true);
            ((URLConnection)object).setDoOutput(true);
            ((URLConnection)object).setAllowUserInteraction(false);
            ((URLConnection)object).setRequestProperty("User-Agent", useragent);
            ((URLConnection)object).setRequestProperty("Accept", "*/*");
            ((URLConnection)object).setRequestProperty("Icy-Metadata", "1");
            ((URLConnection)object).setRequestProperty("Connection", "close");
            bufferedInputStream = new BufferedInputStream(((URLConnection)object).getInputStream());
        } else {
            bufferedInputStream = new BufferedInputStream(uRL.openStream());
        }
        try {
            if (DEBUG) {
                System.err.println("Using AppletMpegSPIWorkaround to get codec (AudioFileFormat:url)");
            }
            object = AppletMpegSPIWorkaround.getAudioFileFormatForUrl(bufferedInputStream);
            return object;
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    public static AudioFileFormat getAudioFileFormatForUrl(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            if (DEBUG) {
                System.err.println("Using AppletMpegSPIWorkaround to get codec (AudioFileFormat)");
            }
            try {
                Class.forName("javazoom.spi.mpeg.sampled.file.MpegAudioFileReader");
                AudioFileFormat audioFileFormat = new MpegAudioFileReader().getAudioFileFormat(inputStream, -1L);
                return audioFileFormat;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("Mpeg codec not properly installed");
            }
        }
    }

    public static AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        try {
            try {
                throw new Exception();
            }
            catch (Exception exception) {
                if (DEBUG) {
                    System.err.println("Using AppletMpegSPIWorkaround to get codec (AudioFileFormat)");
                }
                try {
                    Class.forName("javazoom.spi.mpeg.sampled.file.MpegAudioFileReader");
                    inputStream.mark(4096);
                    AudioFileFormat audioFileFormat = new MpegAudioFileReader().getAudioFileFormat(inputStream);
                    return audioFileFormat;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalArgumentException("Mpeg codec not properly installed");
                }
            }
        }
        finally {
            inputStream.reset();
        }
    }

    public static AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            if (DEBUG) {
                System.err.println("Using AppletMpegSPIWorkaround to get codec");
            }
            try {
                Class.forName("javazoom.spi.mpeg.sampled.file.MpegAudioFileReader");
                return new MpegAudioFileReader().getAudioInputStream(inputStream);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("Mpeg codec not properly installed");
            }
        }
    }
}

