/*
 * Decompiled with CFR 0.152.
 */
package net.sf.image4j.codec.ico;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.sf.image4j.codec.bmp.BMPDecoder;
import net.sf.image4j.codec.bmp.ColorEntry;
import net.sf.image4j.codec.bmp.InfoHeader;
import net.sf.image4j.codec.ico.ICOImage;
import net.sf.image4j.codec.ico.IconEntry;
import net.sf.image4j.io.LittleEndianInputStream;

public class ICODecoder {
    private static final int PNG_MAGIC = -1991225785;
    private static final int PNG_MAGIC_LE = 1196314761;
    private static final int PNG_MAGIC2 = 218765834;
    private static final int PNG_MAGIC2_LE = 169478669;

    private ICODecoder() {
    }

    public static List read(File file) throws IOException {
        return ICODecoder.read(new FileInputStream(file));
    }

    public static List readExt(File file) throws IOException {
        return ICODecoder.readExt(new FileInputStream(file));
    }

    public static List read(InputStream inputStream) throws IOException {
        List list = ICODecoder.readExt(inputStream);
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            ICOImage iCOImage = (ICOImage)list.get(i);
            BufferedImage bufferedImage = iCOImage.getImage();
            arrayList.add(bufferedImage);
        }
        return arrayList;
    }

    public static List readExt(InputStream inputStream) throws IOException {
        int n;
        LittleEndianInputStream littleEndianInputStream = new LittleEndianInputStream(inputStream);
        short s = littleEndianInputStream.readShortLE();
        short s2 = littleEndianInputStream.readShortLE();
        int n2 = littleEndianInputStream.readShortLE();
        IconEntry[] iconEntryArray = new IconEntry[n2];
        for (n = 0; n < n2; n = (short)(n + 1)) {
            iconEntryArray[n] = new IconEntry(littleEndianInputStream);
        }
        n = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        try {
            for (n = 0; n < n2; ++n) {
                Object object;
                Object object2;
                Object object3;
                ColorEntry[] colorEntryArray;
                Object object4;
                Object object5;
                Object object6;
                int n3 = littleEndianInputStream.readIntLE();
                if (n3 == 40) {
                    int n4;
                    int n5;
                    int n6;
                    InfoHeader infoHeader = BMPDecoder.readInfoHeader(littleEndianInputStream, n3);
                    object6 = new InfoHeader(infoHeader);
                    ((InfoHeader)object6).iHeight = infoHeader.iHeight / 2;
                    object5 = new InfoHeader(infoHeader);
                    object5.iHeight = ((InfoHeader)object6).iHeight;
                    ((InfoHeader)object6).sBitCount = 1;
                    ((InfoHeader)object6).iNumColors = 2;
                    BufferedImage bufferedImage = BMPDecoder.read((InfoHeader)object5, littleEndianInputStream);
                    object4 = new BufferedImage(object5.iWidth, object5.iHeight, 2);
                    colorEntryArray = new ColorEntry[]{new ColorEntry(255, 255, 255, 255), new ColorEntry(0, 0, 0, 0)};
                    if (infoHeader.sBitCount == 32) {
                        int n7 = iconEntryArray[n].iSizeInBytes;
                        int n8 = infoHeader.iSize;
                        int n9 = object5.iWidth * object5.iHeight * 4;
                        int n10 = n7 - n8 - n9;
                        int n11 = littleEndianInputStream.skipBytes(n10);
                        n6 = n10;
                        while (n11 < n6) {
                            if (n11 < 0) {
                                throw new IOException("Failed to read [skip]");
                            }
                            n6 = n10 - n11;
                            n11 = littleEndianInputStream.skipBytes(n6);
                        }
                        object3 = bufferedImage.getRaster();
                        WritableRaster writableRaster = bufferedImage.getAlphaRaster();
                        WritableRaster writableRaster2 = ((BufferedImage)object4).getRaster();
                        WritableRaster writableRaster3 = ((BufferedImage)object4).getAlphaRaster();
                        for (n5 = object5.iHeight - 1; n5 >= 0; --n5) {
                            for (n4 = 0; n4 < object5.iWidth; ++n4) {
                                int n12 = ((Raster)object3).getSample(n4, n5, 0);
                                int n13 = ((Raster)object3).getSample(n4, n5, 1);
                                int n14 = ((Raster)object3).getSample(n4, n5, 2);
                                int n15 = writableRaster.getSample(n4, n5, 0);
                                writableRaster2.setSample(n4, n5, 0, n12);
                                writableRaster2.setSample(n4, n5, 1, n13);
                                writableRaster2.setSample(n4, n5, 2, n14);
                                writableRaster3.setSample(n4, n5, 0, n15);
                            }
                        }
                    } else {
                        object2 = BMPDecoder.read((InfoHeader)object6, littleEndianInputStream, colorEntryArray);
                        object = bufferedImage.getRaster();
                        WritableRaster writableRaster = ((BufferedImage)object4).getRaster();
                        WritableRaster writableRaster4 = ((BufferedImage)object4).getAlphaRaster();
                        WritableRaster writableRaster5 = ((BufferedImage)object2).getRaster();
                        for (n6 = 0; n6 < object5.iHeight; ++n6) {
                            for (int i = 0; i < object5.iWidth; ++i) {
                                n5 = bufferedImage.getRGB(i, n6);
                                int n16 = n5 >> 16 & 0xFF;
                                int n17 = n5 >> 8 & 0xFF;
                                int n18 = n5 & 0xFF;
                                writableRaster.setSample(i, n6, 0, n16);
                                writableRaster.setSample(i, n6, 1, n17);
                                writableRaster.setSample(i, n6, 2, n18);
                                n4 = ((BufferedImage)object2).getRGB(i, n6);
                                writableRaster4.setSample(i, n6, 0, n4);
                            }
                        }
                    }
                    object2 = iconEntryArray[n];
                    object = new ICOImage((BufferedImage)object4, infoHeader, (IconEntry)object2);
                    ((ICOImage)object).setPngCompressed(false);
                    ((ICOImage)object).setIconIndex(n);
                    arrayList.add(object);
                    continue;
                }
                if (n3 == 1196314761) {
                    int n19 = littleEndianInputStream.readIntLE();
                    if (n19 != 169478669) {
                        throw new IOException("Unrecognized icon format for image #" + n);
                    }
                    object6 = iconEntryArray[n];
                    object5 = new byte[((IconEntry)object6).iSizeInBytes - 8];
                    int n20 = littleEndianInputStream.read((byte[])object5);
                    if (n20 != ((byte[])object5).length) {
                        throw new IOException("Unable to read image #" + n + " - incomplete PNG compressed data");
                    }
                    object4 = new ByteArrayOutputStream();
                    colorEntryArray = new DataOutputStream((OutputStream)object4);
                    colorEntryArray.writeInt(-1991225785);
                    colorEntryArray.writeInt(218765834);
                    colorEntryArray.write((byte[])object5);
                    object2 = ((ByteArrayOutputStream)object4).toByteArray();
                    object = new ByteArrayInputStream((byte[])object2);
                    ImageInputStream imageInputStream = ImageIO.createImageInputStream(object);
                    ImageReader imageReader = ICODecoder.getPNGImageReader();
                    imageReader.setInput(imageInputStream);
                    BufferedImage bufferedImage = imageReader.read(0);
                    IconEntry iconEntry = iconEntryArray[n];
                    object3 = new ICOImage(bufferedImage, null, iconEntry);
                    ((ICOImage)object3).setPngCompressed(true);
                    ((ICOImage)object3).setIconIndex(n);
                    arrayList.add(object3);
                    continue;
                }
                throw new IOException("Unrecognized icon format for image #" + n);
            }
        }
        catch (IOException iOException) {
            throw new IOException("Failed to read image # " + n);
        }
        return arrayList;
    }

    private static ImageReader getPNGImageReader() {
        ImageReader imageReader = null;
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("png");
        if (iterator.hasNext()) {
            imageReader = iterator.next();
        }
        return imageReader;
    }
}

