/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.ExtendedByteArrayInputStream;
import edu.xtec.util.StreamIO;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public abstract class ResourceManager {
    public static final String RESOURCE_ROOT = "/edu/xtec/resources/";
    public static final String RESOURCE_CLASS_ROOT = "edu.xtec.resources.";
    public static final StreamIO.InputStreamProvider STREAM_PROVIDER = new StreamIO.InputStreamProvider(){

        public InputStream getInputStream(String string) throws Exception {
            return ResourceManager.getResourceAsStream(string);
        }
    };
    public static final String DEFAULT_LOCALE = "en";
    private static HashMap icons = new HashMap();

    public static ImageIcon getImageIcon(String string) {
        ImageIcon imageIcon = (ImageIcon)icons.get(string);
        if (imageIcon == null) {
            try {
                imageIcon = new ImageIcon(ResourceManager.getResource(string));
                String string2 = string;
                if (string2.startsWith("icons/")) {
                    string2 = new StringBuffer("@").append(string2.substring(6)).substring(0);
                }
                imageIcon.setDescription(string2);
                icons.put(string, imageIcon);
            }
            catch (Exception exception) {
                System.err.println("unable to get image " + string);
                System.err.println(exception);
            }
        }
        return imageIcon;
    }

    public static URL getResource(String string) throws Exception {
        URL uRL = ResourceManager.class.getResource(RESOURCE_ROOT + string);
        if (uRL == null) {
            throw ResourceManager.buildException(string);
        }
        return uRL;
    }

    public static InputStream getResourceAsStream(String string) throws Exception {
        InputStream inputStream = ResourceManager.class.getResourceAsStream(RESOURCE_ROOT + string);
        if (inputStream == null) {
            throw ResourceManager.buildException(string);
        }
        return inputStream;
    }

    public static byte[] getResourceBytes(String string) throws Exception {
        return StreamIO.readInputStream(ResourceManager.getResourceAsStream(string));
    }

    public static ExtendedByteArrayInputStream getResourceAsByteArray(String string) throws Exception {
        return new ExtendedByteArrayInputStream(ResourceManager.getResourceBytes(string), string);
    }

    public static String getResourceText(String string, boolean bl) throws Exception {
        String string2 = bl ? "\r\n" : System.getProperty("line.separator");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ResourceManager.getResourceAsStream(string)));
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = null;
        while ((string3 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string3).append(string2);
        }
        bufferedReader.close();
        return stringBuffer.substring(0);
    }

    public static ResourceBundle getBundle(String string, Locale locale) throws Exception {
        ResourceBundle resourceBundle;
        if (locale != null && DEFAULT_LOCALE.equals(locale.getLanguage())) {
            Locale.setDefault(locale);
        }
        if ((resourceBundle = ResourceBundle.getBundle(RESOURCE_CLASS_ROOT + string, locale)) == null) {
            throw ResourceManager.buildException(string);
        }
        return resourceBundle;
    }

    private static Exception buildException(String string) {
        return new Exception("Unable to load resource: " + string);
    }
}

