/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.PlayerSettings;
import edu.xtec.jclic.project.LibraryManager;
import edu.xtec.jclic.project.LibraryManagerElement;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class NewLibraryDlg
extends JPanel {
    PlayerSettings settings;
    Options options;
    private JRadioButton btOptionLink;
    private JRadioButton btOptionNew;
    private JButton fileBrowseBtn;
    private JTextField fileText;

    public NewLibraryDlg(PlayerSettings playerSettings) {
        this.settings = playerSettings;
        this.options = playerSettings.rb.getOptions();
        this.initComponents();
    }

    private void initComponents() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btOptionNew = new JRadioButton();
        this.btOptionLink = new JRadioButton();
        JLabel jLabel = new JLabel();
        this.fileText = new JTextField();
        this.fileBrowseBtn = new JButton();
        this.setLayout(new GridBagLayout());
        this.btOptionNew.setSelected(true);
        this.btOptionNew.setText(this.options.getMsg("libraryManager_newLibaryOption"));
        buttonGroup.add(this.btOptionNew);
        this.btOptionNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewLibraryDlg.this.btOptionNewActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 6, 2);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.btOptionNew, gridBagConstraints);
        this.btOptionLink.setText(this.options.getMsg("libraryManager_connectToExistingOption"));
        buttonGroup.add(this.btOptionLink);
        this.btOptionLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewLibraryDlg.this.btOptionLinkActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(6, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.btOptionLink, gridBagConstraints);
        jLabel.setText(this.options.getMsg("libraryManager_fileOrUrlCaption"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 20, 2, 2);
        this.add((Component)jLabel, gridBagConstraints);
        this.fileText.setPreferredSize(new Dimension(200, 20));
        this.fileText.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.fileText, gridBagConstraints);
        this.fileBrowseBtn.setText("...");
        this.fileBrowseBtn.setToolTipText(this.options.getMsg("BROWSE_FILES"));
        this.fileBrowseBtn.setEnabled(false);
        this.fileBrowseBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewLibraryDlg.this.fileBrowseBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.fileBrowseBtn, gridBagConstraints);
    }

    private void fileBrowseBtnActionPerformed(ActionEvent actionEvent) {
        int[] nArray = new int[]{0};
        String string = this.settings.fileSystem.chooseFile(this.settings.rootPath + File.separator + ".", false, nArray, this.settings.rb.getOptions(), null, this, false);
        if (string != null) {
            this.fileText.setText(this.settings.fileSystem.getFullFileNamePath(string));
        }
    }

    private void btOptionLinkActionPerformed(ActionEvent actionEvent) {
        this.checkEnabled();
    }

    private void btOptionNewActionPerformed(ActionEvent actionEvent) {
        this.checkEnabled();
    }

    public void checkEnabled() {
        this.fileText.setEnabled(this.btOptionLink.isSelected());
        this.fileBrowseBtn.setEnabled(this.btOptionLink.isSelected());
    }

    public static LibraryManagerElement getLibraryManagerElement(LibraryManager libraryManager, Component component) {
        NewLibraryDlg newLibraryDlg = new NewLibraryDlg(libraryManager.settings);
        Messages messages = libraryManager.settings.rb.getOptions().getMessages();
        LibraryManagerElement libraryManagerElement = null;
        while (libraryManagerElement == null && messages.showInputDlg(component, newLibraryDlg, "libraryManager_newLibraryTitle")) {
            if (newLibraryDlg.btOptionNew.isSelected()) {
                libraryManagerElement = libraryManager.createNewProjectLibrary(null, null);
                break;
            }
            String string = StrUtils.nullableString(newLibraryDlg.fileText.getText());
            if (string == null) {
                messages.showAlert(component, "libraryManager_warnNoFileSelected");
                continue;
            }
            libraryManagerElement = libraryManager.locateNewProjectLibrary(string);
        }
        return libraryManagerElement;
    }
}

