/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.media.AudioPlayer;
import edu.xtec.jclic.media.EventSounds;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Options;
import org.jdom.Element;

public class EventSoundsElement
implements Domable,
Cloneable {
    protected String fileName;
    protected int enabled;
    protected AudioPlayer player;
    protected String id;
    public static final String ELEMENT_NAME = "sound";
    public static final String ID = "id";
    public static final String FILE = "file";

    public EventSoundsElement(String string) {
        this.id = string;
        this.enabled = 2;
        this.fileName = null;
        this.player = null;
    }

    public String getId() {
        return this.id;
    }

    public Element getJDomElement() {
        if (this.id == null || this.enabled == 2 && this.fileName == null) {
            return null;
        }
        Element element = new Element(ELEMENT_NAME);
        element.setAttribute(ID, this.id);
        if (this.enabled != 2) {
            element.setAttribute("enabled", JDomUtility.triStateString(this.enabled));
        }
        if (this.fileName != null) {
            element.setAttribute(FILE, this.fileName);
        }
        return element;
    }

    public static EventSoundsElement getEventSoundsElement(Element element) throws Exception {
        String string = JDomUtility.getStringAttr(element, ID, element.getName(), false);
        if (string == null || string.length() < 1 || ELEMENT_NAME.equals(string)) {
            throw new Exception("Invalid event sound element id: " + string);
        }
        EventSoundsElement eventSoundsElement = new EventSoundsElement(string);
        eventSoundsElement.setProperties(element, null);
        return eventSoundsElement;
    }

    public void setProperties(Element element, Object object) throws Exception {
        this.enabled = JDomUtility.getTriStateAttr(element, "enabled", this.enabled);
        this.fileName = JDomUtility.getStringAttr(element, FILE, this.fileName, false);
    }

    public void setFileName(String string) {
        if (this.player != null) {
            this.player.close();
        }
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setEnabled(int n) {
        if (JDomUtility.checkTriState(n)) {
            this.enabled = n;
            if (this.player != null) {
                this.player.stop();
            }
        }
    }

    public int getEnabled() {
        return this.enabled;
    }

    private void buildPlayer(Options options) {
        this.close();
        String string = options.getString("mediaSystem");
        String string2 = null;
        string2 = "edu.xtec.jclic.media.JavaSoundAudioPlayer";
        if (string2 != null) {
            try {
                Class<?> clazz = Class.forName(string2);
                this.player = (AudioPlayer)clazz.newInstance();
            }
            catch (Exception exception) {
                System.err.println("Error building audio player:\n" + exception);
            }
        }
    }

    public boolean setDataSource(Object object, Options options) throws Exception {
        this.buildPlayer(options);
        return this.player == null ? false : this.player.setDataSource(object);
    }

    public void realize(Options options, MediaBag mediaBag) throws Exception {
        if (this.player == null) {
            this.buildPlayer(options);
        }
        this.player.realize(this.fileName, mediaBag);
    }

    public void close() {
        if (this.player != null) {
            this.player.close();
            this.player = null;
        }
    }

    public void play() {
        if (this.player != null && this.enabled != 0 && EventSounds.globalEnabled) {
            this.player.play();
        }
    }

    public void stop() {
        if (this.player != null) {
            this.player.stop();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public Object clone() {
        EventSoundsElement eventSoundsElement = new EventSoundsElement(this.id);
        eventSoundsElement.fileName = this.fileName;
        eventSoundsElement.enabled = this.enabled;
        eventSoundsElement.player = this.player;
        return eventSoundsElement;
    }
}

