/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.fileSystem;

import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.fileSystem.FileZip;
import edu.xtec.jclic.fileSystem.UrlZip;
import edu.xtec.util.ExtendedByteArrayInputStream;
import edu.xtec.util.ResourceBridge;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.zip.ZipEntry;

public abstract class ZipFileSystem
extends FileSystem {
    String zipName;
    protected boolean loaded;
    ExtendedZipEntry[] entries;

    public ZipFileSystem(ResourceBridge resourceBridge) {
        super("", resourceBridge);
        this.entries = null;
        this.zipName = null;
        this.loaded = false;
    }

    public ZipFileSystem(String string, String string2, ResourceBridge resourceBridge) {
        super(string, resourceBridge);
        this.zipName = this.getCanonicalNameOf(string2);
        this.entries = null;
        this.loaded = false;
    }

    public static final ZipFileSystem createZipFileSystem(String string, String string2, ResourceBridge resourceBridge) throws Exception {
        if (ZipFileSystem.isStrUrl(string)) {
            return new UrlZip(string, string2, resourceBridge);
        }
        return new FileZip(string, string2, resourceBridge);
    }

    public String getFullRoot() {
        return this.root + this.zipName;
    }

    public ExtendedZipEntry getEntry(String string) {
        if (string == null || string.length() == 0 || this.entries == null) {
            return null;
        }
        String string2 = this.getCanonicalNameOf(string);
        for (int i = 0; i < this.entries.length; ++i) {
            if (this.entries[i].ignore || !this.entries[i].getName().equals(string2)) continue;
            return this.entries[i];
        }
        return null;
    }

    public byte[] getBytes(String string) throws IOException {
        ExtendedZipEntry extendedZipEntry = this.getEntry(string);
        if (extendedZipEntry == null) {
            return super.getBytes(string);
        }
        return extendedZipEntry.getBytes();
    }

    public boolean fileExists(String string) {
        return super.fileExists(string);
    }

    public long getFileLength(String string) throws IOException {
        ExtendedZipEntry extendedZipEntry = this.getEntry(string);
        if (extendedZipEntry == null) {
            return super.getFileLength(string);
        }
        return extendedZipEntry.getSize();
    }

    public Image getImageFile(String string) throws Exception {
        ExtendedZipEntry extendedZipEntry = this.getEntry(string);
        if (extendedZipEntry == null) {
            return super.getImageFile(string);
        }
        return Toolkit.getDefaultToolkit().createImage(extendedZipEntry.getBytes());
    }

    public InputStream getInputStream(String string) throws IOException {
        ExtendedZipEntry extendedZipEntry = this.getEntry(string);
        if (extendedZipEntry == null) {
            return super.getInputStream(string);
        }
        return extendedZipEntry.getInputStream();
    }

    public Object getMediaDataSource(String string) throws Exception {
        ExtendedZipEntry extendedZipEntry = this.getEntry(string);
        if (extendedZipEntry == null) {
            return super.getMediaDataSource(string);
        }
        return new ExtendedByteArrayInputStream(extendedZipEntry.getBytes(), string);
    }

    public String[] getEntries(String string) throws Exception {
        String[] stringArray = null;
        if (this.entries != null && this.entries.length > 0) {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < this.entries.length; ++i) {
                String string2 = this.entries[i].getName();
                if (string != null && !string2.endsWith(string)) continue;
                vector.add(string2);
            }
            if (!vector.isEmpty()) {
                stringArray = vector.toArray(new String[vector.size()]);
            }
        }
        return stringArray;
    }

    public void close() {
        this.entries = null;
        super.close();
    }

    public abstract class ExtendedZipEntry
    extends ZipEntry {
        public boolean ignore;

        ExtendedZipEntry(ZipEntry zipEntry) {
            super(zipEntry);
        }

        public abstract byte[] getBytes() throws IOException;

        public abstract InputStream getInputStream() throws IOException;

        public String getName() {
            return FileSystem.stdFn(super.getName());
        }
    }
}

