/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.fileSystem;

import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class FileBackup {
    File file;
    File backup;
    Vector createdDirs;
    static final String BAK_EXT = ".bak";

    public FileBackup(File file) throws IOException {
        this.file = file;
        if (file.exists() && file.isFile()) {
            this.backup = new File(file.getAbsolutePath() + BAK_EXT);
            if (this.backup.exists()) {
                this.backup.delete();
            }
            file.renameTo(this.backup);
        } else if (!file.exists() && file.getParentFile() != null && !file.getParentFile().exists()) {
            this.createdDirs = new Vector(2);
            for (File file2 = file.getParentFile(); file2 != null && !file2.exists(); file2 = file2.getParentFile()) {
                this.createdDirs.add(file2);
            }
            file.getParentFile().mkdirs();
        }
    }

    public void rollback() throws IOException {
        if (this.backup != null) {
            if (this.file.exists()) {
                this.file.delete();
            }
            this.backup.renameTo(this.file);
            this.backup = null;
        } else {
            this.file.delete();
            this.file = null;
            if (this.createdDirs != null) {
                for (int i = 0; i < this.createdDirs.size(); ++i) {
                    File file = (File)this.createdDirs.get(i);
                    if (!file.isDirectory()) continue;
                    file.delete();
                }
                this.createdDirs = null;
            }
        }
    }

    public void cleanup() throws IOException {
        if (this.backup != null) {
            this.backup.delete();
            this.backup = null;
        }
    }

    public File getFile() {
        return this.file;
    }

    public File getBackup() {
        return this.backup;
    }
}

