/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.boxes.Resizable;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import javax.swing.JComponent;

public class BoxBag
extends AbstractBox
implements Cloneable,
Resizable {
    protected ArrayList cells = new ArrayList(12);
    protected Rectangle2D preferredBounds = new Rectangle2D.Double();
    protected AbstractBox backgroundBox = null;

    public BoxBag(AbstractBox abstractBox, JComponent jComponent, BoxBase boxBase) {
        super(abstractBox, jComponent, boxBase);
        this.preferredBounds.setRect(this.getBounds());
    }

    public Object clone() {
        BoxBag boxBag = (BoxBag)super.clone();
        boxBag.preferredBounds = (Rectangle2D)this.preferredBounds.clone();
        boxBag.cells = new ArrayList();
        for (int i = 0; i < this.cells.size(); ++i) {
            boxBag.cells.add(this.getBox(i).clone());
        }
        if (this.backgroundBox != null) {
            boxBag.backgroundBox = (AbstractBox)this.backgroundBox.clone();
            boxBag.backgroundBox.setParent(boxBag);
        }
        return boxBag;
    }

    public void setContainer(JComponent jComponent) {
        super.setContainer(jComponent);
    }

    public void end() {
        for (int i = 0; i < this.cells.size(); ++i) {
            this.getBox(i).end();
        }
        if (this.backgroundBox != null) {
            this.backgroundBox.end();
            this.backgroundBox = null;
        }
        this.cells.clear();
        super.end();
    }

    public Dimension getPreferredSize() {
        return this.preferredBounds.getBounds().getSize();
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.getPreferredSize();
        return new Dimension(Math.max(10, dimension.width), Math.max(10, dimension.height));
    }

    public Dimension getScaledSize(double d) {
        Dimension dimension = this.getPreferredSize();
        return new Dimension((int)(d * (double)dimension.width), (int)(d * (double)dimension.height));
    }

    public void ensureCapacity(int n) {
        this.cells.ensureCapacity(n);
    }

    public void addBox(AbstractBox abstractBox) {
        this.cells.add(abstractBox);
        abstractBox.setParent(this);
        if (this.cells.size() == 1) {
            super.setBounds(abstractBox);
        } else {
            this.add(abstractBox);
        }
        this.preferredBounds.setRect(this.getBounds());
    }

    public int boxIndex(Object object) {
        return object == null ? -1 : this.cells.indexOf(object);
    }

    public AbstractBox getBox(int n) {
        return n < 0 || n >= this.cells.size() ? null : (AbstractBox)this.cells.get(n);
    }

    public AbstractBox getBackgroundBox() {
        return this.backgroundBox;
    }

    public void setBackgroundBox(AbstractBox abstractBox) {
        this.backgroundBox = abstractBox;
        if (this.backgroundBox != null) {
            this.add(this.backgroundBox);
            this.backgroundBox.setParent(this);
        }
        this.preferredBounds.setRect(this.getBounds());
    }

    public void recalcSize() {
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.x, this.y, 0.0, 0.0);
        if (this.backgroundBox != null) {
            double_.add(this.backgroundBox);
        }
        for (int i = 0; i < this.cells.size(); ++i) {
            double_.add((AbstractBox)this.cells.get(i));
        }
        this.preferredBounds.setRect(double_);
        this.x = ((RectangularShape)double_).getX();
        this.y = ((RectangularShape)double_).getY();
        this.width = ((RectangularShape)double_).getWidth();
        this.height = ((RectangularShape)double_).getHeight();
    }

    public int getNumCells() {
        return this.cells.size();
    }

    public void setBorder(boolean bl) {
        for (int i = 0; i < this.cells.size(); ++i) {
            this.getBox(i).setBorder(bl);
        }
    }

    public void setVisible(boolean bl) {
        for (int i = 0; i < this.cells.size(); ++i) {
            this.getBox(i).setVisible(bl);
        }
    }

    public void setAlternative(boolean bl) {
        super.setAlternative(bl);
        for (int i = 0; i < this.cells.size(); ++i) {
            this.getBox(i).setAlternative(bl);
        }
    }

    public void setBoxBase(BoxBase boxBase) {
        super.setBoxBase(boxBase);
    }

    public void setBounds(Rectangle2D rectangle2D) {
        if (!rectangle2D.isEmpty() && !rectangle2D.equals(this)) {
            Cloneable cloneable;
            double d = rectangle2D.getWidth() / this.width;
            double d2 = rectangle2D.getHeight() / this.height;
            double d3 = rectangle2D.getX() - this.x;
            double d4 = rectangle2D.getY() - this.y;
            for (int i = 0; i < this.cells.size(); ++i) {
                cloneable = this.getBox(i);
                Point2D.Double double_ = new Point2D.Double(cloneable.x - this.x, cloneable.y - this.y);
                cloneable.setBounds(d3 + this.x + d * double_.x, d4 + this.y + d2 * double_.y, d * cloneable.width, d2 * cloneable.height);
            }
            if (this.backgroundBox != null) {
                AbstractBox abstractBox = this.backgroundBox;
                cloneable = new Point2D.Double(abstractBox.x - this.x, abstractBox.y - this.y);
                abstractBox.setBounds(d3 + this.x + d * ((Point2D.Double)cloneable).x, d4 + this.y + d2 * ((Point2D.Double)cloneable).y, d * abstractBox.width, d2 * abstractBox.height);
            }
        }
        super.setBounds(rectangle2D);
    }

    public boolean update(Graphics2D graphics2D, Rectangle rectangle, ImageObserver imageObserver) {
        AbstractBox abstractBox;
        int n;
        if (this.isEmpty() || !this.isVisible() || this.isTemporaryHidden()) {
            return false;
        }
        if (!this.intersects(rectangle)) {
            return false;
        }
        if (this.backgroundBox != null) {
            this.backgroundBox.update(graphics2D, rectangle, imageObserver);
        }
        for (n = 0; n < this.cells.size(); ++n) {
            abstractBox = this.getBox(n);
            if (abstractBox.isMarked()) continue;
            abstractBox.update(graphics2D, rectangle, imageObserver);
        }
        for (n = 0; n < this.cells.size(); ++n) {
            abstractBox = this.getBox(n);
            if (!abstractBox.isMarked()) continue;
            abstractBox.update(graphics2D, rectangle, imageObserver);
        }
        return true;
    }

    public boolean updateContent(Graphics2D graphics2D, Rectangle rectangle, ImageObserver imageObserver) {
        return true;
    }

    public AbstractBox findBox(Point2D point2D) {
        AbstractBox abstractBox = null;
        for (int i = this.cells.size() - 1; i >= 0; --i) {
            abstractBox = this.getBox(i);
            if (!abstractBox.isVisible() || !abstractBox.contains(point2D)) continue;
            return abstractBox;
        }
        return null;
    }

    public int countInactiveCells() {
        int n = 0;
        for (int i = 0; i < this.cells.size(); ++i) {
            if (!this.getBox(i).isInactive()) continue;
            ++n;
        }
        return n;
    }

    public static Dimension layoutSingle(Dimension dimension, Resizable resizable, int n) {
        Dimension dimension2 = resizable.getPreferredSize();
        Dimension dimension3 = resizable.getMinimumSize();
        Dimension dimension4 = dimension;
        dimension4.width -= 2 * n;
        dimension4.height -= 2 * n;
        if (dimension3.width > dimension4.width || dimension3.height > dimension4.height) {
            dimension4 = dimension3;
        }
        double d = 1.0;
        if (dimension2.width > dimension4.width) {
            d = (double)dimension4.width / (double)dimension2.width;
        }
        if (d * (double)dimension2.height > (double)dimension4.height) {
            d = (double)dimension4.height / (double)dimension2.height;
        }
        dimension2 = resizable.getScaledSize(d);
        resizable.setBounds(n, n, dimension2.width, dimension2.height);
        dimension2.width += 2 * n;
        dimension2.height += 2 * n;
        return dimension2;
    }

    public static Dimension layoutDouble(Dimension dimension, Resizable resizable, Resizable resizable2, int n, int n2) {
        boolean bl = false;
        int n3 = 1;
        int n4 = 1;
        switch (n) {
            case 0: 
            case 1: {
                n3 = 2;
                n4 = 1;
                bl = true;
                break;
            }
            case 2: 
            case 3: {
                n3 = 1;
                n4 = 2;
                bl = false;
            }
        }
        Rectangle2D rectangle2D = resizable.getBounds2D();
        Rectangle2D rectangle2D2 = resizable2.getBounds2D();
        Dimension dimension2 = resizable.getPreferredSize();
        Dimension dimension3 = resizable2.getPreferredSize();
        Dimension dimension4 = new Dimension(bl ? dimension2.width + dimension3.width : Math.max(dimension2.width, dimension3.width), bl ? Math.max(dimension2.height, dimension3.height) : dimension2.height + dimension3.height);
        Dimension dimension5 = resizable.getMinimumSize();
        Dimension dimension6 = resizable2.getMinimumSize();
        Dimension dimension7 = new Dimension(bl ? dimension5.width + dimension6.width : Math.max(dimension5.width, dimension6.width), bl ? Math.max(dimension5.height, dimension6.height) : dimension5.height + dimension6.height);
        Dimension dimension8 = dimension;
        dimension8.width -= (1 + n3) * n2;
        dimension8.height -= (1 + n4) * n2;
        if (dimension7.width > dimension8.width || dimension7.height > dimension8.height) {
            dimension8.setSize(dimension7);
        }
        double d = 1.0;
        if (dimension4.width > dimension8.width) {
            d = (double)dimension8.width / (double)dimension4.width;
        }
        if (d * (double)dimension4.height > (double)dimension8.height) {
            d = (double)dimension8.height / (double)dimension4.height;
        }
        dimension2 = resizable.getScaledSize(d);
        dimension3 = resizable2.getScaledSize(d);
        int n5 = dimension3.width > dimension2.width ? (dimension3.width - dimension2.width) / 2 : 0;
        int n6 = dimension2.width > dimension3.width ? (dimension2.width - dimension3.width) / 2 : 0;
        int n7 = dimension3.height > dimension2.height ? (dimension3.height - dimension2.height) / 2 : 0;
        int n8 = dimension2.height > dimension3.height ? (dimension2.height - dimension3.height) / 2 : 0;
        switch (n) {
            case 0: {
                resizable.setBounds(n2, n2 + n7, dimension2.width, dimension2.height);
                resizable2.setBounds(2 * n2 + dimension2.width, n2 + n8, dimension3.width, dimension3.height);
                break;
            }
            case 1: {
                resizable2.setBounds(n2, n2 + n8, dimension3.width, dimension3.height);
                resizable.setBounds(2 * n2 + dimension3.width, n2 + n7, dimension2.width, dimension2.height);
                break;
            }
            case 2: {
                resizable.setBounds(n2 + n5, n2, dimension2.width, dimension2.height);
                resizable2.setBounds(n2 + n6, 2 * n2 + dimension2.height, dimension3.width, dimension3.height);
                break;
            }
            case 3: {
                resizable2.setBounds(n2 + n6, n2, dimension3.width, dimension3.height);
                resizable.setBounds(n2 + n5, 2 * n2 + dimension3.height, dimension2.width, dimension2.height);
                break;
            }
            default: {
                resizable.setBounds((int)((double)n2 + d * rectangle2D.getX()), (int)((double)n2 + d * rectangle2D.getY()), dimension2.width, dimension2.height);
                resizable2.setBounds((int)((double)n2 + d * rectangle2D2.getX()), (int)((double)n2 + d * rectangle2D2.getY()), dimension2.width, dimension2.height);
            }
        }
        Rectangle rectangle = new Rectangle(resizable.getBounds());
        rectangle.add(resizable2.getBounds());
        dimension4.width = rectangle.width + 2 * n2;
        dimension4.height = rectangle.height + 2 * n2;
        return dimension4;
    }
}

