/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.main.Resources;
import freemind.main.Tools;
import freemind.view.mindmapview.MainView;
import freemind.view.mindmapview.NodeMotionListenerView;
import freemind.view.mindmapview.NodeView;
import freemind.view.mindmapview.NodeViewLayoutAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;

public class VerticalRootNodeViewLayout
extends NodeViewLayoutAdapter {
    private static final String USE_COMMON_OUT_POINT_FOR_ROOT_NODE_STRING = "use_common_out_point_for_root_node";
    static boolean USE_COMMON_OUT_POINT_FOR_ROOT_NODE = Resources.getInstance().getBoolProperty("use_common_out_point_for_root_node");
    private static VerticalRootNodeViewLayout instance = null;

    protected void layout() {
        int rightContentHeight = this.getChildContentHeight(false);
        int rightChildVerticalShift = this.getChildVerticalShift(false);
        int leftContentHeight = this.getChildContentHeight(true);
        int leftChildVerticalShift = this.getChildVerticalShift(true);
        int childHorizontalShift = this.getChildHorizontalShift();
        int contentHeight = Math.max(rightContentHeight, leftContentHeight);
        int x = Math.max(this.getSpaceAround(), -childHorizontalShift);
        if (this.getView().getModel().isVisible()) {
            this.getContent().setVisible(true);
            Dimension contentPreferredSize = this.getContent().getPreferredSize();
            int childVerticalShift = Math.min(rightChildVerticalShift += (contentPreferredSize.height - rightContentHeight) / 2, leftChildVerticalShift += (contentPreferredSize.height - leftContentHeight) / 2);
            int y = Math.max(this.getSpaceAround(), -childVerticalShift);
            this.getContent().setBounds(x, y, contentPreferredSize.width, contentPreferredSize.height);
        } else {
            this.getContent().setVisible(false);
            int childVerticalShift = Math.min(rightChildVerticalShift, leftChildVerticalShift);
            int y = Math.max(this.getSpaceAround(), -childVerticalShift);
            this.getContent().setBounds(x, y, 0, contentHeight);
        }
        this.placeLeftChildren(leftChildVerticalShift);
        int width1 = this.getView().getWidth();
        int height1 = this.getView().getHeight();
        this.placeRightChildren(rightChildVerticalShift);
        int width2 = this.getView().getWidth();
        int height2 = this.getView().getHeight();
        this.getView().setSize(Math.max(width1, width2), Math.max(height1, height2));
    }

    static VerticalRootNodeViewLayout getInstance() {
        if (instance == null) {
            instance = new VerticalRootNodeViewLayout();
        }
        return instance;
    }

    public void layoutNodeMotionListenerView(NodeMotionListenerView view) {
        NodeView movedView = view.getMovedView();
        JComponent content = movedView.getContent();
        this.location.x = 0;
        this.location.y = -10;
        Tools.convertPointToAncestor((Component)content, this.location, view.getParent());
        view.setLocation(this.location);
        view.setSize(content.getWidth(), 10);
    }

    public Point getMainViewOutPoint(NodeView view, NodeView targetView, Point destinationPoint) {
        MainView mainView = view.getMainView();
        if (USE_COMMON_OUT_POINT_FOR_ROOT_NODE) {
            if (targetView.isLeft()) {
                return mainView.getLeftPoint();
            }
            return mainView.getRightPoint();
        }
        Point p = new Point(destinationPoint);
        Tools.convertPointFromAncestor(view, p, mainView);
        double nWidth = (float)mainView.getWidth() / 2.0f;
        double nHeight = (float)mainView.getHeight() / 2.0f;
        Point centerPoint = new Point((int)nWidth, (int)nHeight);
        double angle = Math.atan(((float)(p.y - centerPoint.y) + 0.0f) / ((float)(p.x - centerPoint.x) + 0.0f));
        if (p.x < centerPoint.x) {
            angle += Math.PI;
        }
        Point out = new Point(centerPoint.x + (int)(Math.cos(angle) * nWidth), centerPoint.y + (int)(Math.sin(angle) * nHeight));
        return out;
    }

    public Point getMainViewInPoint(NodeView view) {
        Point centerPoint = view.getMainView().getCenterPoint();
        return centerPoint;
    }
}

