/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.modes.MindMapNode;
import freemind.view.mindmapview.NodeView;
import freemind.view.mindmapview.NodeViewLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;

public abstract class NodeViewLayoutAdapter
implements NodeViewLayout {
    protected final int LISTENER_VIEW_WIDTH = 10;
    protected Point location = new Point();
    private static Dimension minDimension;
    private NodeView view;
    private MindMapNode model;
    private int childCount;
    private JComponent content;
    private int vGap;
    private int spaceAround;

    public void addLayoutComponent(String arg0, Component arg1) {
    }

    public void removeLayoutComponent(Component arg0) {
    }

    public Dimension minimumLayoutSize(Container arg0) {
        if (minDimension == null) {
            minDimension = new Dimension(0, 0);
        }
        return minDimension;
    }

    public Dimension preferredLayoutSize(Container c) {
        if (!c.isValid()) {
            c.validate();
        }
        return c.getSize();
    }

    public void layoutContainer(Container c) {
        this.setUp(c);
        this.layout();
        this.shutDown();
    }

    protected abstract void layout();

    private void setUp(Container c) {
        NodeView localView = (NodeView)c;
        localView.syncronizeAttributeView();
        int localChildCount = localView.getComponentCount() - 1;
        for (int i = 0; i < localChildCount; ++i) {
            localView.getComponent(i).validate();
        }
        this.view = localView;
        this.model = localView.getModel();
        this.childCount = localChildCount;
        this.content = localView.getContent();
        this.vGap = this.getModel().isVisible() ? this.getView().getVGap() : this.getView().getVisibleParentView().getVGap();
        this.spaceAround = this.view.getMap().getZoomed(50);
    }

    private void shutDown() {
        this.view = null;
        this.model = null;
        this.content = null;
        this.childCount = 0;
        this.vGap = 0;
        this.spaceAround = 0;
    }

    protected NodeView getView() {
        return this.view;
    }

    protected MindMapNode getModel() {
        return this.model;
    }

    protected int getChildCount() {
        return this.childCount;
    }

    protected JComponent getContent() {
        return this.content;
    }

    protected int getChildContentHeight(boolean isLeft) {
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return 0;
        }
        int height = 0;
        int count = 0;
        for (int i = 0; i < childCount; ++i) {
            NodeView child = (NodeView)this.getView().getComponent(i);
            if (child.isLeft() != isLeft) continue;
            int additionalCloudHeigth = child.getAdditionalCloudHeigth();
            int contentHeight = child.getContent().getHeight();
            height += contentHeight + additionalCloudHeigth;
            ++count;
        }
        return height + this.vGap * (count - 1);
    }

    protected int getChildVerticalShift(boolean isLeft) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        int shift = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            NodeView child = (NodeView)this.getView().getComponent(i);
            if (child.isLeft() != isLeft) continue;
            int childShift = child.getShift();
            if (childShift < 0 || i == 0) {
                shift += childShift;
            }
            shift -= child.getContent().getY() - this.getSpaceAround();
        }
        return shift - this.getSpaceAround();
    }

    protected int getChildHorizontalShift() {
        if (this.getChildCount() == 0) {
            return 0;
        }
        int shift = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            int shiftCandidate;
            NodeView child = (NodeView)this.getView().getComponent(i);
            if (child.isLeft()) {
                shiftCandidate = -child.getContent().getX() - child.getContent().getWidth();
                if (child.getModel().isVisible()) {
                    shiftCandidate -= child.getHGap() + child.getAdditionalCloudHeigth() / 2;
                }
            } else {
                shiftCandidate = -child.getContent().getX();
                if (child.getModel().isVisible()) {
                    shiftCandidate += child.getHGap();
                }
            }
            shift = Math.min(shift, shiftCandidate);
        }
        return shift;
    }

    protected void placeRightChildren(int childVerticalShift) {
        int baseX = this.getContent().getX() + this.getContent().getWidth();
        int y = this.getContent().getY() + childVerticalShift;
        int right = baseX + this.getSpaceAround();
        NodeView child = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            NodeView component = (NodeView)this.getView().getComponent(i);
            if (component.isLeft()) continue;
            child = component;
            int additionalCloudHeigth = child.getAdditionalCloudHeigth() / 2;
            y += additionalCloudHeigth;
            int shiftY = child.getShift();
            int childHGap = child.getContent().isVisible() ? child.getHGap() : 0;
            int x = baseX + childHGap - child.getContent().getX();
            if (shiftY < 0) {
                child.setLocation(x, y);
                y -= shiftY;
            } else {
                child.setLocation(x, y += shiftY);
            }
            y += child.getHeight() - 2 * this.getSpaceAround() + this.getVGap() + additionalCloudHeigth;
            right = Math.max(right, x + child.getWidth() + additionalCloudHeigth);
        }
        int bottom = this.getContent().getY() + this.getContent().getHeight() + this.getSpaceAround();
        if (child != null) {
            this.getView().setSize(right, Math.max(bottom, child.getY() + child.getHeight() + child.getAdditionalCloudHeigth() / 2));
        } else {
            this.getView().setSize(right, bottom);
        }
    }

    protected void placeLeftChildren(int childVerticalShift) {
        int baseX = this.getContent().getX();
        int y = this.getContent().getY() + childVerticalShift;
        int right = baseX + this.getContent().getWidth() + this.getSpaceAround();
        NodeView child = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            NodeView component = (NodeView)this.getView().getComponent(i);
            if (!component.isLeft()) continue;
            child = component;
            int additionalCloudHeigth = child.getAdditionalCloudHeigth() / 2;
            y += additionalCloudHeigth;
            int shiftY = child.getShift();
            int childHGap = child.getContent().isVisible() ? child.getHGap() : 0;
            int x = baseX - childHGap - child.getContent().getX() - child.getContent().getWidth();
            if (shiftY < 0) {
                child.setLocation(x, y);
                y -= shiftY;
            } else {
                child.setLocation(x, y += shiftY);
            }
            y += child.getHeight() - 2 * this.getSpaceAround() + this.getVGap() + additionalCloudHeigth;
            right = Math.max(right, x + child.getWidth());
        }
        int bottom = this.getContent().getY() + this.getContent().getHeight() + this.getSpaceAround();
        if (child != null) {
            this.getView().setSize(right, Math.max(bottom, child.getY() + child.getHeight() + child.getAdditionalCloudHeigth() / 2));
        } else {
            this.getView().setSize(right, bottom);
        }
    }

    int getVGap() {
        return this.vGap;
    }

    int getSpaceAround() {
        return this.spaceAround;
    }
}

