/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.main.Tools;
import freemind.modes.ModeController;
import freemind.view.mindmapview.EditNodeBase;
import freemind.view.mindmapview.NodeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class EditNodeDialog
extends EditNodeBase {
    private KeyEvent firstEvent;
    private static Tools.BooleanHolder booleanHolderForConfirmState;

    public EditNodeDialog(NodeView node, String text, KeyEvent firstEvent, ModeController controller, EditNodeBase.EditControl editControl) {
        super(node, text, controller, editControl);
        this.firstEvent = firstEvent;
    }

    public void show() {
        LongNodeDialog dialog = new LongNodeDialog();
        dialog.pack();
        this.getView().scrollNodeToVisible(this.getNode(), 0);
        Tools.setDialogLocationRelativeTo(dialog, this.getNode().getMainView());
        ((Dialog)dialog).show();
    }

    class LongNodeDialog
    extends EditNodeBase.EditDialog {
        private JTextArea textArea;

        LongNodeDialog() {
            super(EditNodeDialog.this);
            this.textArea = new JTextArea(EditNodeDialog.this.getText());
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
            JScrollPane editorScrollPane = new JScrollPane(this.textArea);
            editorScrollPane.setVerticalScrollBarPolicy(22);
            int preferredHeight = EditNodeDialog.this.getNode().getHeight();
            preferredHeight = Math.max(preferredHeight, Integer.parseInt(EditNodeDialog.this.getFrame().getProperty("el__min_default_window_height")));
            preferredHeight = Math.min(preferredHeight, Integer.parseInt(EditNodeDialog.this.getFrame().getProperty("el__max_default_window_height")));
            int preferredWidth = EditNodeDialog.this.getNode().getWidth();
            preferredWidth = Math.max(preferredWidth, Integer.parseInt(EditNodeDialog.this.getFrame().getProperty("el__min_default_window_width")));
            preferredWidth = Math.min(preferredWidth, Integer.parseInt(EditNodeDialog.this.getFrame().getProperty("el__max_default_window_width")));
            editorScrollPane.setPreferredSize(new Dimension(preferredWidth, preferredHeight));
            JPanel panel = new JPanel();
            JButton okButton = new JButton();
            JButton cancelButton = new JButton();
            JButton splitButton = new JButton();
            final JCheckBox enterConfirms = new JCheckBox("", EditNodeDialog.this.binOptionIsTrue("el__enter_confirms_by_default"));
            Tools.setLabelAndMnemonic(okButton, EditNodeDialog.this.getText("ok"));
            Tools.setLabelAndMnemonic(cancelButton, EditNodeDialog.this.getText("cancel"));
            Tools.setLabelAndMnemonic(splitButton, EditNodeDialog.this.getText("split"));
            Tools.setLabelAndMnemonic(enterConfirms, EditNodeDialog.this.getText("enter_confirms"));
            if (booleanHolderForConfirmState == null) {
                booleanHolderForConfirmState = new Tools.BooleanHolder();
                booleanHolderForConfirmState.setValue(enterConfirms.isSelected());
            } else {
                enterConfirms.setSelected(booleanHolderForConfirmState.getValue());
            }
            okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LongNodeDialog.this.submit();
                }
            });
            cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LongNodeDialog.this.cancel();
                }
            });
            splitButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LongNodeDialog.this.split();
                }
            });
            enterConfirms.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LongNodeDialog.this.textArea.requestFocus();
                    booleanHolderForConfirmState.setValue(enterConfirms.isSelected());
                }
            });
            this.textArea.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        e.consume();
                        LongNodeDialog.this.confirmedCancel();
                    } else if (e.getKeyCode() == 10) {
                        if (enterConfirms.isSelected() && (e.getModifiers() & 1) != 0) {
                            e.consume();
                            LongNodeDialog.this.textArea.insert("\n", LongNodeDialog.this.textArea.getCaretPosition());
                        } else if (enterConfirms.isSelected() || (e.getModifiers() & 8) != 0) {
                            e.consume();
                            LongNodeDialog.this.submit();
                        } else {
                            e.consume();
                            LongNodeDialog.this.textArea.insert("\n", LongNodeDialog.this.textArea.getCaretPosition());
                        }
                    }
                }

                public void keyTyped(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                }
            });
            this.textArea.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                    this.conditionallyShowPopup(e);
                }

                public void mouseReleased(MouseEvent e) {
                    this.conditionallyShowPopup(e);
                }

                private void conditionallyShowPopup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        EditNodeBase.EditPopupMenu popupMenu = new EditNodeBase.EditPopupMenu(LongNodeDialog.this.textArea);
                        popupMenu.show(e.getComponent(), e.getX(), e.getY());
                        e.consume();
                    }
                }
            });
            Font nodeFont = EditNodeDialog.this.getNode().getTextFont();
            this.textArea.setFont(nodeFont);
            Color nodeTextColor = EditNodeDialog.this.getNode().getTextColor();
            this.textArea.setForeground(nodeTextColor);
            Color nodeTextBackground = EditNodeDialog.this.getNode().getTextBackground();
            this.textArea.setBackground(nodeTextBackground);
            this.textArea.setCaretColor(nodeTextColor);
            JPanel buttonPane = new JPanel();
            buttonPane.add(enterConfirms);
            buttonPane.add(okButton);
            buttonPane.add(cancelButton);
            buttonPane.add(splitButton);
            buttonPane.setMaximumSize(new Dimension(1000, 20));
            if (EditNodeDialog.this.getFrame().getProperty("el__buttons_position").equals("above")) {
                panel.add(buttonPane);
                panel.add(editorScrollPane);
            } else {
                panel.add(editorScrollPane);
                panel.add(buttonPane);
            }
            panel.setLayout(new BoxLayout(panel, 1));
            this.setContentPane(panel);
            EditNodeDialog.this.redispatchKeyEvents(this.textArea, EditNodeDialog.this.firstEvent);
        }

        public void show() {
            this.textArea.requestFocus();
            super.show();
        }

        protected void cancel() {
            EditNodeDialog.this.getEditControl().cancel();
            super.cancel();
        }

        protected void split() {
            EditNodeDialog.this.getEditControl().split(this.textArea.getText(), this.textArea.getCaretPosition());
            super.split();
        }

        protected void submit() {
            EditNodeDialog.this.getEditControl().ok(this.textArea.getText());
            super.submit();
        }

        protected boolean isChanged() {
            return !EditNodeDialog.this.getText().equals(this.textArea.getText());
        }

        public Component getMostRecentFocusOwner() {
            if (this.isFocused()) {
                return this.getFocusOwner();
            }
            return this.textArea;
        }
    }
}

