/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.common;

import freemind.main.Resources;
import freemind.modes.ModeController;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.logging.Logger;
import javax.swing.KeyStroke;

public class CommonNodeKeyListener
implements KeyListener {
    private ModeController c;
    private String up;
    private String down;
    private String left;
    private String right;
    private boolean disabledKeyType = true;
    private boolean keyTypeAddsNew = false;
    private KeyStroke keyStrokeUp;
    private KeyStroke keyStrokeDown;
    private KeyStroke keyStrokeLeft;
    private KeyStroke keyStrokeRight;
    private final EditHandler editHandler;
    private static Logger logger;

    public CommonNodeKeyListener(ModeController controller, EditHandler editHandler) {
        this.c = controller;
        this.editHandler = editHandler;
        if (logger == null) {
            logger = controller.getFrame().getLogger(this.getClass().getName());
        }
        this.up = this.c.getFrame().getAdjustableProperty("keystroke_move_up");
        this.down = this.c.getFrame().getAdjustableProperty("keystroke_move_down");
        this.left = this.c.getFrame().getAdjustableProperty("keystroke_move_left");
        this.right = this.c.getFrame().getAdjustableProperty("keystroke_move_right");
        this.disabledKeyType = Resources.getInstance().getBoolProperty("disable_key_type");
        this.keyTypeAddsNew = Resources.getInstance().getBoolProperty("key_type_adds_new");
        this.keyStrokeUp = KeyStroke.getKeyStroke(this.up);
        this.keyStrokeDown = KeyStroke.getKeyStroke(this.down);
        this.keyStrokeLeft = KeyStroke.getKeyStroke(this.left);
        this.keyStrokeRight = KeyStroke.getKeyStroke(this.right);
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        logger.finest("Key pressend " + e.getKeyChar());
        if (e.isAltDown() || e.isControlDown() || e.isMetaDown()) {
            return;
        }
        switch (e.getKeyCode()) {
            case 9: 
            case 10: 
            case 16: 
            case 27: 
            case 32: 
            case 127: 
            case 155: {
                return;
            }
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.c.getView().move(e);
                return;
            }
            case 8: 
            case 35: 
            case 36: {
                this.editHandler.edit(e, false, false);
                return;
            }
        }
        if (!this.disabledKeyType && !e.isActionKey() && e.getKeyChar() != '\uffff') {
            logger.finest("Starting edit mode with: " + e.getKeyChar());
            this.editHandler.edit(e, this.keyTypeAddsNew, false);
            return;
        }
        boolean doMove = false;
        if (this.keyStrokeUp != null && e.getKeyCode() == this.keyStrokeUp.getKeyCode()) {
            e.setKeyCode(38);
            doMove = true;
        } else if (this.keyStrokeDown != null && e.getKeyCode() == this.keyStrokeDown.getKeyCode()) {
            e.setKeyCode(40);
            doMove = true;
        } else if (this.keyStrokeLeft != null && e.getKeyCode() == this.keyStrokeLeft.getKeyCode()) {
            e.setKeyCode(37);
            doMove = true;
        } else if (this.keyStrokeRight != null && e.getKeyCode() == this.keyStrokeRight.getKeyCode()) {
            e.setKeyCode(39);
            doMove = true;
        }
        if (doMove) {
            this.c.getView().move(e);
            e.consume();
            return;
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 16) {
            this.c.getView().resetShiftSelectionOrigin();
        }
    }

    public static interface EditHandler {
        public void edit(KeyEvent var1, boolean var2, boolean var3);
    }
}

