/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.browsemode;

import freemind.modes.ControllerAdapter;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.common.plugins.NodeNoteBase;
import freemind.view.mindmapview.NodeView;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class NodeNoteViewer
extends NodeNoteBase
implements ModeController.NodeSelectionListener {
    private JComponent noteScrollPane;
    private JLabel noteViewer;
    private final ControllerAdapter mBrowseController;
    private static ImageIcon noteIcon = null;

    public NodeNoteViewer(ControllerAdapter pBrowseController) {
        this.mBrowseController = pBrowseController;
    }

    protected JComponent getNoteViewerComponent(String text) {
        if (this.noteViewer == null) {
            this.noteViewer = new JLabel();
            this.noteViewer.setBackground(Color.WHITE);
            this.noteViewer.setVerticalAlignment(1);
            this.noteViewer.setOpaque(true);
            this.noteScrollPane = new JScrollPane(this.noteViewer);
            this.noteScrollPane.setPreferredSize(new Dimension(1, 200));
        }
        this.noteViewer.setText(text != null ? text : "");
        return this.noteScrollPane;
    }

    public void onDeselectHook(NodeView pNode) {
        this.mBrowseController.getFrame().removeSplitPane();
    }

    public void onSelectHook(NodeView pNode) {
        String noteText = pNode.getModel().getNoteText();
        if (noteText != null && !noteText.equals("")) {
            this.mBrowseController.getFrame().insertComponentIntoSplitPane(this.getNoteViewerComponent(noteText));
        }
    }

    public void onSaveNode(MindMapNode pNode) {
    }

    public void onUpdateNodeHook(MindMapNode pNode) {
        this.setStateIcon(pNode, true);
    }

    protected void setStateIcon(MindMapNode node, boolean enabled) {
        if (noteIcon == null) {
            noteIcon = new ImageIcon(this.mBrowseController.getResource("images/knotes.png"));
        }
        node.setStateIcon(this.getClass().getName(), enabled ? noteIcon : null);
    }
}

