/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.browsemode;

import freemind.main.FreeMindMain;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.main.XMLParseException;
import freemind.modes.ControllerAdapter;
import freemind.modes.MapAdapter;
import freemind.modes.MindIcon;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import freemind.modes.browsemode.BrowseNodeModel;
import freemind.modes.common.dialogs.EnterPasswordDialog;
import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public class EncryptedBrowseNode
extends BrowseNodeModel {
    private static ImageIcon encryptedIcon;
    private static ImageIcon decryptedIcon;
    private String encryptedContent;
    private boolean isDecrypted = false;
    protected static Logger logger;
    private final ModeController mModeController;

    public EncryptedBrowseNode(FreeMindMain frame, ModeController modeController) {
        this(null, frame, modeController);
    }

    public EncryptedBrowseNode(Object userObject, FreeMindMain frame, ModeController modeController) {
        super(userObject, frame, modeController.getMap());
        this.mModeController = modeController;
        if (logger == null) {
            logger = frame.getLogger(this.getClass().getName());
        }
        if (encryptedIcon == null) {
            encryptedIcon = MindIcon.factory("encrypted").getIcon();
        }
        if (decryptedIcon == null) {
            decryptedIcon = MindIcon.factory("decrypted").getIcon();
        }
        this.updateIcon();
    }

    public void updateIcon() {
        this.setStateIcon("encryptedNode", this.isDecrypted ? decryptedIcon : encryptedIcon);
    }

    public void setFolded(boolean folded) {
        if (this.isDecrypted || folded) {
            super.setFolded(folded);
            return;
        }
        ControllerAdapter browseController = (ControllerAdapter)this.mModeController;
        EnterPasswordDialog pwdDialog = new EnterPasswordDialog(null, browseController, false);
        pwdDialog.setModal(true);
        pwdDialog.show();
        if (pwdDialog.getResult() == -1) {
            return;
        }
        Tools.SingleDesEncrypter encrypter = new Tools.SingleDesEncrypter(pwdDialog.getPassword());
        String decrypted = encrypter.decrypt(this.encryptedContent);
        if (decrypted == null) {
            return;
        }
        String[] childs = decrypted.split("<nodeseparator>");
        for (int i = childs.length - 1; i >= 0; --i) {
            String string = childs[i];
            logger.finest("Decrypted '" + string + "'.");
            if (string.length() == 0) continue;
            try {
                NodeAdapter node = (NodeAdapter)browseController.createNodeTreeFromXml(new StringReader(string));
                browseController.insertNodeInto(node, this);
                MapAdapter model = browseController.getModel();
                browseController.invokeHooksRecursively(node, model);
                super.setFolded(folded);
                browseController.nodeChanged(this);
                browseController.nodeStructureChanged(this);
                this.isDecrypted = true;
                this.updateIcon();
                continue;
            }
            catch (XMLParseException e) {
                Resources.getInstance().logException(e);
                return;
            }
            catch (IOException e) {
                Resources.getInstance().logException(e);
                return;
            }
        }
    }

    public void setAdditionalInfo(String info) {
        this.encryptedContent = info;
        this.isDecrypted = false;
    }
}

