/*
 * Decompiled with CFR 0.152.
 */
package freemind.main;

import freemind.main.FreeMindMain;
import freemind.main.Resources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class FreeMindCommon {
    public static final String FREEMIND_FILE_EXTENSION_WITHOUT_DOT = "mm";
    public static final String FREEMIND_FILE_EXTENSION = ".mm";
    public static final String POSTFIX_TRANSLATE_ME = "[translate me]";
    public static final String RESOURCE_LANGUAGE = "language";
    public static final String RESOURCE_ANTIALIAS = "antialias";
    public static final String DEFAULT_LANGUAGE = "en";
    public static final String LOCAL_PROPERTIES = "LocalProperties.";
    private final FreeMindMain mFreeMindMain;
    private String baseDir;
    private FreemindResourceBundle resources;
    public static final String ON_START_IF_NOT_SPECIFIED = "onStartIfNotSpecified";
    public static final String LOAD_LAST_MAP = "loadLastMap";
    public static final String SAVE_ONLY_INTRISICALLY_NEEDED_IDS = "save_only_intrisically_needed_ids";
    private static Logger logger = null;

    public FreeMindCommon(FreeMindMain main) {
        this.mFreeMindMain = main;
        if (logger == null) {
            logger = main.getLogger(this.getClass().getName());
        }
    }

    public String getProperty(String key) {
        return this.mFreeMindMain.getProperty(key);
    }

    private void setDefaultProperty(String key, String value) {
        this.mFreeMindMain.setDefaultProperty(key, value);
    }

    public ResourceBundle getResources() {
        if (this.resources == null) {
            this.resources = new FreemindResourceBundle();
        }
        return this.resources;
    }

    public String getResourceString(String key) {
        return ((FreemindResourceBundle)this.getResources()).getResourceString(key);
    }

    public String getResourceString(String key, String resource) {
        return ((FreemindResourceBundle)this.getResources()).getResourceString(key, resource);
    }

    public void clearLanguageResources() {
        this.resources = null;
    }

    public ClassLoader getFreeMindClassLoader() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            return new URLClassLoader(new URL[]{new File(this.getFreemindBaseDir()).toURI().toURL()}, classLoader);
        }
        catch (MalformedURLException e) {
            Resources.getInstance().logException(e);
            return classLoader;
        }
    }

    public String getFreemindBaseDirOld() {
        if (this.baseDir == null) {
            String classPath = System.getProperty("java.class.path");
            String mainJarFile = "freemind.jar";
            int lastpos = classPath.indexOf("freemind.jar");
            int firstpos = 0;
            if (lastpos == -1) {
                this.baseDir = System.getProperty("user.dir");
                logger.info("Basedir is user.dir: " + this.baseDir);
                return this.baseDir;
            }
            if (--lastpos > (firstpos = classPath.lastIndexOf(File.pathSeparator, lastpos) + 1)) {
                logger.info("First " + firstpos + " and last " + lastpos + " and string " + classPath);
                this.baseDir = classPath.substring(firstpos, lastpos);
            } else {
                this.baseDir = "";
            }
            File basePath = new File(this.baseDir);
            this.baseDir = basePath.getAbsolutePath();
            logger.info("First basedir is: " + this.baseDir);
            lastpos = this.baseDir.lastIndexOf(File.separator);
            if (lastpos > -1) {
                this.baseDir = this.baseDir.substring(0, lastpos);
            }
            logger.info("Basedir is: " + this.baseDir);
        }
        return this.baseDir;
    }

    public String getFreemindBaseDir() {
        if (this.baseDir == null) {
            try {
                File file;
                String dir = System.getProperty("freemind.base.dir");
                if (dir == null) {
                    String classname = this.getClass().getName();
                    URL url = this.getClass().getResource(classname.replaceFirst("^" + this.getClass().getPackage().getName() + ".", "") + ".class");
                    file = new File(URLDecoder.decode(url.getPath().replaceFirst("^(file:|jar:)+", "").replaceFirst("!.*$", "").replaceFirst(classname.replace('.', '/') + ".class$", ""), "UTF-8"));
                    if (file.isFile()) {
                        file = file.getParentFile();
                    }
                    if (file.getName().equals("lib")) {
                        file = file.getParentFile();
                    }
                } else {
                    file = new File(dir);
                }
                if (!file.exists()) {
                    throw new IllegalArgumentException("FreeMind base dir '" + file + "' does not exist.");
                }
                if (!file.isDirectory()) {
                    throw new IllegalArgumentException("FreeMind base dir (!) '" + file + "' is not a directory.");
                }
                this.baseDir = file.getCanonicalPath();
                logger.info("Basedir is: " + this.baseDir);
            }
            catch (Exception e) {
                Resources.getInstance().logException(e);
                throw new IllegalArgumentException("FreeMind base dir can't be determined.");
            }
        }
        return this.baseDir;
    }

    public String getAdjustableProperty(String label) {
        String value = this.getProperty(label);
        if (value == null) {
            return value;
        }
        if (value.startsWith("?") && !value.equals("?")) {
            String localValue = ((FreemindResourceBundle)this.getResources()).getResourceString(LOCAL_PROPERTIES + label, null);
            value = localValue == null ? value.substring(1).trim() : localValue;
            this.setDefaultProperty(label, value);
        }
        return value;
    }

    public void loadUIProperties(Properties props) {
    }

    private class FreemindResourceBundle
    extends ResourceBundle {
        private PropertyResourceBundle languageResources;
        private PropertyResourceBundle defaultResources;

        FreemindResourceBundle() {
            try {
                String lang = FreeMindCommon.this.getProperty(FreeMindCommon.RESOURCE_LANGUAGE);
                if ((lang == null || lang.equals("automatic")) && this.getLanguageResources(lang = Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry()) == null && this.getLanguageResources(lang = Locale.getDefault().getLanguage()) == null) {
                    lang = FreeMindCommon.DEFAULT_LANGUAGE;
                }
                if ("no".equals(lang)) {
                    lang = "nb";
                }
                this.languageResources = this.getLanguageResources(lang);
                this.defaultResources = this.getLanguageResources(FreeMindCommon.DEFAULT_LANGUAGE);
            }
            catch (Exception ex) {
                Resources.getInstance().logException(ex);
                logger.severe("Error loading Resources");
            }
        }

        private PropertyResourceBundle getLanguageResources(String lang) throws IOException {
            URL systemResource = FreeMindCommon.this.mFreeMindMain.getResource("Resources_" + lang + ".properties");
            if (systemResource == null) {
                return null;
            }
            InputStream in = systemResource.openStream();
            if (in == null) {
                return null;
            }
            PropertyResourceBundle bundle = new PropertyResourceBundle(in);
            in.close();
            return bundle;
        }

        protected Object handleGetObject(String key) {
            try {
                return this.languageResources.getString(key);
            }
            catch (Exception ex) {
                logger.severe("Warning - resource string not found:" + key);
                return this.defaultResources.getString(key) + FreeMindCommon.POSTFIX_TRANSLATE_ME;
            }
        }

        public Enumeration getKeys() {
            return this.defaultResources.getKeys();
        }

        String getResourceString(String key) {
            try {
                return this.getString(key);
            }
            catch (Exception ex) {
                return key;
            }
        }

        String getResourceString(String key, String resource) {
            try {
                return this.languageResources.getString(key);
            }
            catch (Exception ex) {
                try {
                    return this.defaultResources.getString(key) + FreeMindCommon.POSTFIX_TRANSLATE_ME;
                }
                catch (Exception e) {
                    return resource;
                }
            }
        }
    }
}

