/*
 * Decompiled with CFR 0.152.
 */
package freemind.main;

import freemind.controller.Controller;
import freemind.controller.MenuBar;
import freemind.main.FreeMind;
import freemind.main.FreeMindCommon;
import freemind.main.FreeMindMain;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.view.mindmapview.MapView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class FreeMindApplet
extends JApplet
implements FreeMindMain {
    public static final FreeMindMain.VersionInformation version = FreeMind.VERSION;
    public URL defaultPropsURL;
    public static Properties defaultProps;
    public static Properties userProps;
    private JScrollPane scrollPane = new MapView.ScrollPane();
    private MenuBar menuBar;
    private JLabel status;
    Controller c;
    private FreeMindCommon mFreeMindCommon = new FreeMindCommon(this);
    private JPanel southPanel;
    private JComponent mComponentInSplitPane;
    static int iMaxNodeWidth;

    public FreeMindApplet() {
        Resources.createInstance(this);
    }

    public boolean isApplet() {
        return true;
    }

    public File getPatternsFile() {
        return null;
    }

    public Controller getController() {
        return this.c;
    }

    public MapView getView() {
        return this.c.getView();
    }

    public void setView(MapView view) {
        this.scrollPane.setViewportView(view);
    }

    public MenuBar getFreeMindMenuBar() {
        return this.menuBar;
    }

    public Container getViewport() {
        return this.scrollPane.getViewport();
    }

    public FreeMindMain.VersionInformation getFreemindVersion() {
        return version;
    }

    public int getWinHeight() {
        return this.getRootPane().getHeight();
    }

    public int getWinWidth() {
        return this.getRootPane().getWidth();
    }

    public int getWinState() {
        return 6;
    }

    public int getWinX() {
        return 0;
    }

    public int getWinY() {
        return 0;
    }

    public ResourceBundle getResources() {
        return this.mFreeMindCommon.getResources();
    }

    public String getResourceString(String resource) {
        return this.mFreeMindCommon.getResourceString(resource);
    }

    public String getResourceString(String key, String resource) {
        return this.mFreeMindCommon.getResourceString(key, resource);
    }

    public String getProperty(String key) {
        return userProps.getProperty(key);
    }

    public int getIntProperty(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.getProperty(key));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public Properties getProperties() {
        return userProps;
    }

    public void setProperty(String key, String value) {
    }

    public void setDefaultProperty(String key, String value) {
        userProps.setProperty(key, value);
    }

    public String getFreemindDirectory() {
        return null;
    }

    public static int getMaxNodeWidth() {
        if (iMaxNodeWidth == 0) {
            try {
                iMaxNodeWidth = Integer.parseInt(userProps.getProperty("max_node_width"));
            }
            catch (NumberFormatException nfe) {
                iMaxNodeWidth = Integer.parseInt(userProps.getProperty("el__max_default_window_width"));
            }
        }
        return iMaxNodeWidth;
    }

    public void saveProperties() {
    }

    public void setTitle(String title) {
    }

    public void out(String msg) {
        this.status.setText(msg);
    }

    public void err(String msg) {
        this.status.setText("ERROR: " + msg);
    }

    public void openDocument(URL doc) throws Exception {
        this.getAppletContext().showDocument(doc, "_blank");
    }

    public void start() {
        try {
            if (this.getView() != null) {
                this.getView().moveToRoot();
            } else {
                System.err.println("View is null.");
            }
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
        }
    }

    public void setWaitingCursor(boolean waiting) {
        if (waiting) {
            this.getRootPane().getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            this.getRootPane().getGlassPane().setVisible(true);
        } else {
            this.getRootPane().getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
            this.getRootPane().getGlassPane().setVisible(false);
        }
    }

    public URL getResource(String name) {
        URL resourceURL = this.getClass().getResource("/" + name);
        if (resourceURL == null || !resourceURL.getProtocol().equals("jar")) {
            return null;
        }
        return resourceURL;
    }

    public Logger getLogger(String forClass) {
        return Logger.getAnonymousLogger();
    }

    public void init() {
        JRootPane rootPane = this.createRootPane();
        this.defaultPropsURL = this.getResource("freemind.properties");
        try {
            defaultProps = new Properties();
            InputStream in = this.defaultPropsURL.openStream();
            defaultProps.load(in);
            in.close();
            userProps = defaultProps;
        }
        catch (Exception ex) {
            System.err.println("Could not load properties.");
        }
        this.updateLookAndFeel();
        Enumeration<?> allKeys = userProps.propertyNames();
        while (allKeys.hasMoreElements()) {
            String key = (String)allKeys.nextElement();
            this.setPropertyByParameter(key);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.c = new Controller(this);
        this.c.optionAntialiasAction.changeAntialias(this.getProperty("antialias"));
        this.menuBar = new MenuBar(this.c);
        this.setJMenuBar(this.menuBar);
        this.c.setToolbarVisible(false);
        this.c.setMenubarVisible(false);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.southPanel = new JPanel(new BorderLayout());
        this.status = new JLabel();
        this.southPanel.add((Component)this.status, "South");
        this.getContentPane().add((Component)this.southPanel, "South");
        SwingUtilities.updateComponentTreeUI(this);
        if (!EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                    }
                });
            }
            catch (InterruptedException e) {
                Resources.getInstance().logException(e);
            }
            catch (InvocationTargetException e) {
                Resources.getInstance().logException(e);
            }
        }
        this.c.createNewMode(this.getProperty("initial_mode"));
        String initialMapName = this.getProperty("browsemode_initial_map");
        if (initialMapName != null && initialMapName.startsWith(".")) {
            try {
                URL documentBaseUrl = new URL(this.getDocumentBase(), initialMapName);
                initialMapName = documentBaseUrl.toString();
            }
            catch (MalformedURLException e) {
                this.getController().errorMessage("Could not open relative URL " + initialMapName + ". It is malformed.");
                System.err.println(e);
                return;
            }
        }
        if (initialMapName != "") {
            try {
                URL mapUrl = new URL(initialMapName);
                this.getController().getModeController().load(mapUrl);
            }
            catch (Exception e) {
                Resources.getInstance().logException(e);
            }
        }
    }

    private void setPropertyByParameter(String key) {
        String val = this.getParameter(key);
        if (val != null && val != "") {
            userProps.setProperty(key, val);
        }
    }

    private void updateLookAndFeel() {
        String lookAndFeel = "";
        try {
            this.setPropertyByParameter("lookandfeel");
            lookAndFeel = userProps.getProperty("lookandfeel");
            if (lookAndFeel.equals("windows")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            } else if (lookAndFeel.equals("motif")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
            } else if (lookAndFeel.equals("mac")) {
                UIManager.setLookAndFeel("javax.swing.plaf.mac.MacLookAndFeel");
            } else if (lookAndFeel.equals("metal")) {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            } else if (lookAndFeel.equals("gtk")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            } else if (!lookAndFeel.equals("nothing")) {
                if (lookAndFeel.indexOf(46) != -1) {
                    UIManager.setLookAndFeel(lookAndFeel);
                } else {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            }
        }
        catch (Exception ex) {
            System.err.println("Error while setting Look&Feel" + lookAndFeel);
        }
        this.mFreeMindCommon.loadUIProperties(userProps);
        userProps.put("standarddrawrectangleforselection", Tools.BooleanToXml(true));
    }

    public JPanel getSouthPanel() {
        return this.southPanel;
    }

    public JFrame getJFrame() {
        throw new IllegalArgumentException("The applet has no frames");
    }

    public ClassLoader getFreeMindClassLoader() {
        return this.mFreeMindCommon.getFreeMindClassLoader();
    }

    public String getFreemindBaseDir() {
        return this.mFreeMindCommon.getFreemindBaseDir();
    }

    public String getAdjustableProperty(String label) {
        return this.mFreeMindCommon.getAdjustableProperty(label);
    }

    public JSplitPane insertComponentIntoSplitPane(JComponent pMindMapComponent) {
        this.mComponentInSplitPane = pMindMapComponent;
        this.southPanel.add((Component)pMindMapComponent, "Center");
        this.southPanel.revalidate();
        return null;
    }

    public void removeSplitPane() {
        if (this.mComponentInSplitPane != null) {
            this.southPanel.remove(this.mComponentInSplitPane);
            this.southPanel.revalidate();
            this.mComponentInSplitPane = null;
        }
    }

    static {
        iMaxNodeWidth = 0;
    }
}

