/*
 * Decompiled with CFR 0.152.
 */
package freemind.extensions;

import freemind.controller.actions.generated.instance.Plugin;
import freemind.controller.actions.generated.instance.PluginClasspath;
import freemind.main.FreeMindMain;
import freemind.main.Resources;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;

public class HookDescriptorBase {
    public static final String FREEMIND_BASE_DIR_STRING = "${freemind.base.dir}";
    private static Logger logger = null;
    protected final Plugin pluginBase;
    protected final FreeMindMain frame;
    protected final String mXmlPluginFile;
    private static HashMap classLoaderCache = new HashMap();

    public HookDescriptorBase(Plugin pluginBase, FreeMindMain frame, String xmlPluginFile) {
        this.pluginBase = pluginBase;
        this.frame = frame;
        this.mXmlPluginFile = xmlPluginFile;
        if (logger == null) {
            logger = frame.getLogger(this.getClass().getName());
        }
    }

    protected String getFromResourceIfNecessary(String string) {
        if (string == null) {
            return string;
        }
        if (string.startsWith("%")) {
            return this.frame.getController().getResourceString(string.substring(1));
        }
        return string;
    }

    protected String getFromPropertiesIfNecessary(String string) {
        if (string == null) {
            return string;
        }
        if (string.startsWith("%")) {
            return this.frame.getProperty(string.substring(1));
        }
        return string;
    }

    private String getPluginDirectory() {
        return this.frame.getFreemindBaseDir() + "/" + new File(this.mXmlPluginFile).getParent();
    }

    public Plugin getPluginBase() {
        return this.pluginBase;
    }

    public List getPluginClasspath() {
        Vector<PluginClasspath> returnValue = new Vector<PluginClasspath>();
        Iterator i = this.pluginBase.getListChoiceList().iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof PluginClasspath)) continue;
            PluginClasspath pluginClasspath = (PluginClasspath)obj;
            returnValue.add(pluginClasspath);
        }
        return returnValue;
    }

    public ClassLoader getPluginClassLoader() {
        List pluginClasspathList = this.getPluginClasspath();
        ClassLoader loader = this.getClassLoader(pluginClasspathList);
        return loader;
    }

    private String createPluginClasspathString(List pluginClasspathList) {
        String result = "";
        Iterator i = pluginClasspathList.iterator();
        while (i.hasNext()) {
            PluginClasspath type = (PluginClasspath)i.next();
            result = result + type.getJar() + ",";
        }
        return result;
    }

    private ClassLoader getClassLoader(List pluginClasspathList) {
        String key = this.createPluginClasspathString(pluginClasspathList);
        if (classLoaderCache.containsKey(key)) {
            return (ClassLoader)classLoaderCache.get(key);
        }
        try {
            URL[] urls = new URL[pluginClasspathList.size()];
            int j = 0;
            Iterator i = pluginClasspathList.iterator();
            while (i.hasNext()) {
                PluginClasspath classPath = (PluginClasspath)i.next();
                String jarString = classPath.getJar();
                File file = new File(jarString);
                if (!file.isAbsolute()) {
                    file = new File(this.getPluginDirectory(), jarString);
                }
                logger.info("file " + file.toURI().toURL() + " exists = " + file.exists());
                urls[j++] = file.toURI().toURL();
            }
            URLClassLoader loader = new URLClassLoader(urls, this.frame.getFreeMindClassLoader());
            classLoaderCache.put(key, loader);
            return loader;
        }
        catch (MalformedURLException e) {
            Resources.getInstance().logException(e);
            return this.getClass().getClassLoader();
        }
    }
}

